@extends('ui.layouts.app')
@php
    $active = 'audit';
    $tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::first();
    $audit = $tenant
        ? \App\Models\AuditLog::with('user')->where('tenant_id', $tenant->id)->where('id', $auditId)->first()
        : null;
@endphp

@section('title', 'Audit Log Details')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Audit Entry</p>
        <h1>Entry {{ $audit?->id ?? $auditId ?? '-' }}</h1>
        <p class="sub">Change log with actor and diff details.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/audit">Back to Audit Log</a>
        <a class="btn btn-primary" href="/exports/audit/{{ $audit?->id ?? $auditId ?? 0 }}/pdf">Export Entry</a>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Actor</div>
        <div class="list">
            <div class="list-item"><span>User</span><span class="chip">{{ $audit?->user?->name ?? 'System' }}</span></div>
            <div class="list-item"><span>Action</span><span class="chip">{{ $audit?->action ?? '-' }}</span></div>
            <div class="list-item"><span>Entity</span><span class="chip">{{ $audit?->entity_type ? ucfirst(str_replace('_', ' ', $audit->entity_type)) : '-' }} {{ $audit?->entity_id ? '#' . $audit->entity_id : '' }}</span></div>
            <div class="list-item"><span>IP</span><span class="chip">{{ $audit?->ip_address ?? '-' }}</span></div>
            <div class="list-item"><span>Channel</span><span class="chip">{{ strtoupper($audit?->channel ?? 'web') }}</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Changes</div>
        <div class="list">
            @if (is_array($audit?->changes) && $audit->changes)
                @foreach ($audit->changes as $field => $value)
                    @php
                        $from = is_array($value) ? ($value['from'] ?? ($value[0] ?? '-')) : '-';
                        $to = is_array($value) ? ($value['to'] ?? ($value[1] ?? '-')) : $value;
                    @endphp
                    <div class="list-item"><span>{{ $field }}</span><span class="chip">{{ $from }} -> {{ $to }}</span></div>
                @endforeach
            @else
                <div class="list-item"><span>No changes recorded</span><span class="chip">-</span></div>
            @endif
        </div>
    </div>
</section>
@endsection
