@extends('ui.layouts.app')
@php
    $active = 'audit';
    $tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::first();
    $logs = $tenant
        ? \App\Models\AuditLog::with('user')->where('tenant_id', $tenant->id)->orderByDesc('created_at')->limit(200)->get()
        : collect();
    $actionOptions = $logs->pluck('action')->filter()->unique()->values();
    $channelOptions = $logs->pluck('channel')->filter()->unique()->values();
@endphp

@section('title', 'Audit Log')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Security</p>
        <h1>Audit Log</h1>
        <p class="sub">Track who changed what and when.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/exports/audit-log.pdf">Export</a>
        <button class="btn btn-primary">Filter</button>
    </div>
</section>

<section class="card filters" data-filter-scope>
    <div class="filter-row">
        <input class="input" placeholder="Search activity" data-filter-input />
        <select class="select" data-filter-status>
            <option value="all">Action: All</option>
            @foreach ($actionOptions as $action)
                <option value="{{ strtolower($action) }}">{{ $action }}</option>
            @endforeach
        </select>
        <select class="select" data-filter-site>
            <option value="all">Channel: All</option>
            @foreach ($channelOptions as $channel)
                <option value="{{ strtolower($channel) }}">{{ strtoupper($channel) }}</option>
            @endforeach
        </select>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Recent Activity</div>
            <div class="card-sub">Tenant-wide changes</div>
        </div>
        <div class="chip">Last 200</div>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Actor</div><div>Action</div><div>Entity</div><div>Changes</div><div>IP</div><div>Time</div>
        </div>
        @forelse ($logs as $log)
            @php
                $actor = $log->user?->name ?? 'System';
                $entity = trim(($log->entity_type ? ucfirst(str_replace('_', ' ', $log->entity_type)) : '') . ($log->entity_id ? ' #' . $log->entity_id : '')) ?: '-';
                $changes = $log->changes ?? [];
                $changeSummary = '-';
                if (is_array($changes) && $changes) {
                    $parts = [];
                    foreach ($changes as $field => $value) {
                        if (is_array($value)) {
                            $from = $value['from'] ?? ($value[0] ?? '');
                            $to = $value['to'] ?? ($value[1] ?? '');
                            $parts[] = "{$field}: {$from} -> {$to}";
                        } else {
                            $parts[] = "{$field}: {$value}";
                        }
                        if (count($parts) >= 2) {
                            break;
                        }
                    }
                    $changeSummary = implode('; ', $parts);
                }
                $action = $log->action ?? 'activity';
                $channel = $log->channel ?? 'web';
                $search = strtolower($actor . ' ' . $action . ' ' . $entity . ' ' . $changeSummary . ' ' . $channel);
            @endphp
            <a class="table-row" href="/ui/audit/{{ $log->id }}" data-row data-row-id="{{ $log->id }}" data-status="{{ strtolower($action) }}" data-site="{{ strtolower($channel) }}" data-search="{{ $search }}">
                <div>{{ $actor }}</div><div>{{ $action }}</div><div>{{ $entity }}</div><div>{{ $changeSummary }}</div><div>{{ $log->ip_address ?? '-' }}</div><div>{{ $log->created_at?->format('M d H:i') ?? '-' }}</div>
            </a>
        @empty
            <div class="table-row">
                <div>No audit entries yet.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>
@endsection
