@extends('ui.layouts.app')
@php($active = 'downtime')

@section('title', 'Downtime')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Operations</p>
        <h1>Downtime & Reasons</h1>
        <p class="sub">Track downtime drivers with standardized reason codes.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Reason Codes</button>
        <button class="btn btn-primary">Log Downtime</button>
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Downtime Trend</div>
                <div class="card-sub">Total hours per week</div>
            </div>
            <div class="chip">Last 8 weeks</div>
        </div>
        <div class="trend-chart">
            <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                <path class="trend-fill" d="M0 64 L40 70 L80 78 L120 72 L160 84 L200 76 L240 88 L260 82 L260 120 L0 120 Z"></path>
                <polyline class="trend-line" points="0,64 40,70 80,78 120,72 160,84 200,76 240,88 260,82"></polyline>
                <circle class="trend-dot" cx="80" cy="78" r="3"></circle>
                <circle class="trend-dot" cx="160" cy="84" r="3"></circle>
                <circle class="trend-dot" cx="260" cy="82" r="3"></circle>
            </svg>
        </div>
        <div class="trend-legend">
            <span>Avg 6.2h</span>
            <span>Unplanned 3.8h</span>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Top Downtime Reasons</div>
                <div class="card-sub">By hours lost</div>
            </div>
            <div class="chip">This month</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 74%"><span>Parts</span></div>
                <div class="chart-bar" style="--value: 58%"><span>Breakdown</span></div>
                <div class="chart-bar" style="--value: 44%"><span>No Operator</span></div>
                <div class="chart-bar" style="--value: 32%"><span>Fuel Delay</span></div>
            </div>
        </div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Latest Downtime Events</div>
            <div class="card-sub">Shift overview</div>
        </div>
        <div class="chip">Last 12 hours</div>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Asset</div><div>Reason</div><div>Start</div><div>Duration</div><div>WO</div><div>Status</div>
        </div>
        <a class="table-row" href="/ui/downtime/DT-102">
            <div>Loader 5</div><div>Waiting Parts</div><div>08:40</div><div>2h 10m</div><div>WO-224</div><div><span class="badge badge-warning">Open</span></div>
        </a>
        <a class="table-row" href="/ui/downtime/DT-103">
            <div>Hauler 12</div><div>Breakdown</div><div>06:15</div><div>1h 05m</div><div>WO-221</div><div><span class="badge badge-live">Resolved</span></div>
        </a>
        <a class="table-row" href="/ui/downtime/DT-104">
            <div>Crusher 2</div><div>No Operator</div><div>05:00</div><div>45m</div><div>-</div><div><span class="badge">Pending</span></div>
        </a>
    </div>
</section>
@endsection


