@extends('ui.layouts.app')
@php($active = 'imports')

@section('title', 'Import Details')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Import Batch</p>
        <h1>Batch {{ $batchId ?? 'IMP-412' }}</h1>
        <p class="sub">Row mapping, validation, and errors.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/imports">Back to Imports</a>
        <button class="btn btn-primary">Resolve Errors</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Summary</div>
        <div class="list">
            <div class="list-item"><span>File</span><span class="chip">fleet_register.csv</span></div>
            <div class="list-item"><span>Created</span><span class="chip">120</span></div>
            <div class="list-item"><span>Updated</span><span class="chip">32</span></div>
            <div class="list-item"><span>Errors</span><span class="badge badge-warning">4</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">AI Mapping</div>
        <div class="list">
            <div class="list-item"><span>Confidence</span><span class="chip">98%</span></div>
            <div class="list-item"><span>Auto Categories</span><span class="chip">Truck, Loader</span></div>
            <div class="list-item"><span>Inferred Meter</span><span class="chip">Hours</span></div>
        </div>
    </div>
</section>

<section class="card">
    <div class="card-title">Error Rows</div>
    <div class="table">
        <div class="table-row table-head">
            <div>Row</div><div>Issue</div><div>Field</div><div>Value</div><div>Status</div><div>Action</div>
        </div>
        <div class="table-row">
            <div>42</div><div>Missing serial</div><div>serial_number</div><div>-</div><div><span class="badge badge-warning">Fix</span></div><div>Edit</div>
        </div>
        <div class="table-row">
            <div>88</div><div>Duplicate tag</div><div>asset_tag</div><div>A-041</div><div><span class="badge">Review</span></div><div>Merge</div>
        </div>
    </div>
</section>
@endsection


