@extends('ui.layouts.app')
@php($active = 'imports')

@section('title', 'Imports')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Bulk Upload</p>
        <h1>Asset Imports</h1>
        <p class="sub">Upload CSV/Excel, auto-map fields, and populate assets.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/exports/import-template.csv">Download Template</a>
        <button class="btn btn-ghost">Upload Service Sheets</button>
        <button class="btn btn-ghost">Upload Invoices</button>
        <button class="btn btn-primary">Upload Asset Register</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Import Summary</div>
        <div class="list">
            <div class="list-item"><span>Created</span><span class="chip">120</span></div>
            <div class="list-item"><span>Updated</span><span class="chip">32</span></div>
            <div class="list-item"><span>Duplicates</span><span class="chip">8</span></div>
            <div class="list-item"><span>Errors</span><span class="chip">4</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">AI Enrichment</div>
        <p class="sub">Auto-categorize assets, suggest PM intervals, infer meters.</p>
        <div class="insight">
            <div class="insight-score">98%</div>
            <div>
                <div class="item-title">Mapping Confidence</div>
                <div class="item-sub">Last upload: 156 rows</div>
            </div>
        </div>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Recent Imports</div>
            <div class="card-sub">Click to resolve issues</div>
        </div>
        <div class="chip">Uploads</div>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Batch</div><div>File</div><div>Status</div><div>Created</div><div>Errors</div><div>Owner</div>
        </div>
        <a class="table-row" href="/ui/imports/IMP-412">
            <div>IMP-412</div><div>fleet_register.csv</div><div><span class="badge badge-live">Completed</span></div><div>120</div><div>4</div><div>Ops Team</div>
        </a>
        <a class="table-row" href="/ui/imports/IMP-410">
            <div>IMP-410</div><div>workshop_assets.csv</div><div><span class="badge">Processing</span></div><div>45</div><div>0</div><div>M. Lee</div>
        </a>
    </div>
</section>
@endsection


