@extends('ui.layouts.app')
@php($active = 'inventory')
@php($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first())
@php($inventoryItems = $tenant ? \App\Models\InventoryItem::with(['part', 'location'])->where('tenant_id', $tenant->id)->get() : collect())
@php($lowStock = $inventoryItems->filter(fn ($item) => $item->min_quantity !== null && $item->quantity <= $item->min_quantity)->count())
@php($backordered = $inventoryItems->filter(fn ($item) => $item->quantity !== null && $item->quantity <= 0)->count())
@php($fastMovers = min(18, $inventoryItems->count()))
@php($locationOptions = $inventoryItems->map(fn ($item) => $item->location?->name)->filter()->unique()->values())

@section('title', 'Inventory')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Stores</p>
        <h1>Parts & Inventory</h1>
        <p class="sub">Min/max levels, reorder points, and usage per work order.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Reorder List</button>
        <button class="btn btn-primary">Add Part</button>
    </div>
</section>

<section class="grid-3">
    <div class="card">
        <div class="card-title">Low Stock</div>
        <div class="metric">{{ $lowStock }}</div>
        <div class="metric-sub">Items below reorder</div>
    </div>
    <div class="card">
        <div class="card-title">Backordered</div>
        <div class="metric">{{ $backordered }}</div>
        <div class="metric-sub">Awaiting vendor</div>
    </div>
    <div class="card">
        <div class="card-title">Fast Movers</div>
        <div class="metric">{{ $fastMovers }}</div>
        <div class="metric-sub">30-day top usage</div>
    </div>
</section>

<section class="card filters" data-filter-scope>
    <div class="filter-row">
        <input class="input" placeholder="Search inventory" data-filter-input />
        <select class="select" data-filter-status>
            <option value="all">Status: All</option>
            <option value="reorder">Reorder</option>
            <option value="healthy">Healthy</option>
        </select>
        <select class="select" data-filter-site>
            <option value="all">Location: All</option>
            @foreach ($locationOptions as $location)
                <option value="{{ strtolower($location) }}">{{ $location }}</option>
            @endforeach
        </select>
        <button class="btn btn-ghost" type="button" data-export-button data-export-type="inventory">Export Selected</button>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Inventory Items</div>
            <div class="card-sub">Main store and site depots</div>
        </div>
        <div class="chip">Main Store</div>
    </div>
    <div class="table">
        <div class="table-row table-head table-row-7">
            <div></div><div>SKU</div><div>Part</div><div>On Hand</div><div>Min</div><div>Max</div><div>Status</div>
        </div>
        @forelse ($inventoryItems as $item)
            @php($needsReorder = $item->min_quantity !== null && $item->quantity <= $item->min_quantity)
            <div class="table-row table-row-7" data-row data-row-id="{{ $item->id }}" data-status="{{ $needsReorder ? 'reorder' : 'healthy' }}" data-site="{{ strtolower($item->location?->name ?? 'main store') }}" data-search="{{ strtolower(($item->part?->sku ?? '') . ' ' . ($item->part?->name ?? '') . ' ' . ($item->location?->name ?? '')) }}">
                <div class="table-select"><input type="checkbox" data-row-select value="{{ $item->id }}" /></div>
                <div><a href="/ui/inventory/{{ $item->id }}">{{ $item->part?->sku ?? '-' }}</a></div>
                <div>{{ $item->part?->name ?? 'Part' }}</div>
                <div>{{ $item->quantity ?? 0 }}</div>
                <div>{{ $item->min_quantity ?? '-' }}</div>
                <div>{{ $item->max_quantity ?? '-' }}</div>
                <div><span class="badge {{ $needsReorder ? 'badge-warning' : 'badge-live' }}">{{ $needsReorder ? 'Reorder' : 'Healthy' }}</span></div>
            </div>
        @empty
            <div class="table-row table-row-7">
                <div></div><div>No inventory items found.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>
@endsection



