<!doctype html>
<html lang="en" data-bs-theme="dark">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Fleet OS')</title>
    <link rel="stylesheet" href="{{ asset('ui-assets/tabler.min.css') }}">
    <script src="{{ asset('ui-assets/tabler.min.js') }}" defer></script>
    @php($hasVite = file_exists(public_path('build/manifest.json')))
    @if ($hasVite)
        @vite(['resources/js/app.js'])
    @else
        <link rel="stylesheet" href="{{ asset('ui-assets/app.css') }}">
        <script src="{{ asset('ui-assets/app.js') }}" defer></script>
    @endif
</head>
<body class="app">
    <div class="bg-grid"></div>
    <div class="app-shell">
        @include('ui.partials.sidebar', ['active' => $active ?? 'dashboard'])
        <div class="app-main">
            @include('ui.partials.topbar')
            <main class="content">
                @yield('content')
            </main>
        </div>
    </div>
    <div class="action-modal" data-ui="action-modal" aria-hidden="true">
        <div class="action-panel">
            <div class="action-head">
                <div>
                    <div class="action-eyebrow">Quick Action</div>
                    <div class="action-title" data-action-title>Action</div>
                    <div class="action-sub" data-action-sub>Preview flow with sample fields.</div>
                </div>
                <button class="btn btn-ghost" type="button" data-action-close>Close</button>
            </div>
            <form class="action-form" data-action-form>
                <div class="action-fields" data-action-fields></div>
                <div class="action-footer">
                    <button class="btn btn-ghost" type="button" data-action-close>Cancel</button>
                    <button class="btn btn-primary" type="submit">Confirm</button>
                </div>
            </form>
        </div>
    </div>
    <div class="chatbot" data-chatbot aria-hidden="true">
        <div class="chatbot-panel">
            <div class="chatbot-head">
                <div>
                    <div class="chatbot-eyebrow">OpenAI Navigator</div>
                    <div class="chatbot-title">Fleet Copilot</div>
                    <div class="chatbot-sub">Ask, navigate, or upload files instantly.</div>
                </div>
                <button class="btn btn-ghost" type="button" data-chatbot-close>Close</button>
            </div>
            <div class="chatbot-body" data-chatbot-body>
                <div class="chatbot-bubble bot">Hi! I can navigate, search, and prepare uploads. Try "open assets" or "upload service sheets".</div>
                <div class="chatbot-quick">
                    <button class="chip" data-chatbot-quick="open dashboard">Open Dashboard</button>
                    <button class="chip" data-chatbot-quick="open assets">Open Assets</button>
                    <button class="chip" data-chatbot-quick="create work order">Create Work Order</button>
                    <button class="chip" data-chatbot-quick="upload asset register">Upload Asset Register</button>
                </div>
            </div>
            <form class="chatbot-input" data-chatbot-form>
                <input class="input" type="text" placeholder="Type a command or ask a question..." data-chatbot-text />
                <label class="chatbot-upload">
                    <input type="file" data-chatbot-file multiple accept=".png,.jpg,.jpeg,.pdf,.xlsx,.xls,.csv,.docx" />
                    Upload
                </label>
                <button class="btn btn-primary" type="submit">Send</button>
            </form>
        </div>
    </div>
    <button class="chatbot-fab" type="button" data-chatbot-open aria-label="Open chatbot">
        AI
    </button>
    <div class="toast" data-ui="toast" role="status" aria-live="polite">Action queued.</div>
    <div class="scrim" data-ui-dismiss="sidebar"></div>
</body>
</html>


