@extends('ui.layouts.app')
@php($active = 'maintenance')
@php($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first())
@php($workOrders = $tenant ? \App\Models\WorkOrder::with('asset')->where('tenant_id', $tenant->id)->latest()->get() : collect())
@php($openCount = $workOrders->where('status', 'open')->count())
@php($completedCount = $workOrders->where('status', 'completed')->count())
@php($totalCount = $workOrders->count())
@php($compliance = $totalCount ? round(($completedCount / $totalCount) * 100) : 0)
@php($recentOrders = $workOrders->take(3))
@php($dueSoon = $workOrders->where('status', 'open')->take(3))
@php($inProgress = $workOrders->where('status', 'in_progress')->take(2))
@php($completed = $workOrders->where('status', 'completed')->take(3))

@section('title', 'Maintenance')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Maintenance</p>
        <h1>Work Orders</h1>
        <p class="sub">Plan, assign, and track service readiness.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Auto-schedule</button>
        <button class="btn btn-primary">New Work Order</button>
    </div>
</section>

<section class="grid-3">
    <article class="card">
        <div class="card-title">Backlog</div>
        <div class="metric">{{ $openCount }}</div>
        <div class="metric-sub">Open work orders</div>
    </article>
    <article class="card">
        <div class="card-title">Maintenance Compliance</div>
        <div class="metric">{{ $compliance }}%</div>
        <div class="metric-sub">On-time PMs</div>
    </article>
    <article class="card">
        <div class="card-title">MTTR</div>
        <div class="metric">3.6 hrs</div>
        <div class="metric-sub">Average repair time</div>
    </article>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Maintenance Load Trend</div>
                <div class="card-sub">Completed jobs per week</div>
            </div>
            <div class="chip">Last 12 weeks</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 48%"><span>W1</span></div>
                <div class="chart-bar" style="--value: 54%"><span>W2</span></div>
                <div class="chart-bar" style="--value: 68%"><span>W3</span></div>
                <div class="chart-bar" style="--value: 60%"><span>W4</span></div>
                <div class="chart-bar" style="--value: 72%"><span>W5</span></div>
                <div class="chart-bar" style="--value: 64%"><span>W6</span></div>
                <div class="chart-bar" style="--value: 76%"><span>W7</span></div>
                <div class="chart-bar" style="--value: 70%"><span>W8</span></div>
                <div class="chart-bar" style="--value: 82%"><span>W9</span></div>
                <div class="chart-bar" style="--value: 74%"><span>W10</span></div>
                <div class="chart-bar" style="--value: 86%"><span>W11</span></div>
                <div class="chart-bar" style="--value: 90%"><span>W12</span></div>
            </div>
            <div class="chart-overlay">
                <div class="chart-stat">
                    <span>Completed</span>
                    <strong>212</strong>
                </div>
                <div class="chart-stat">
                    <span>Overdue</span>
                    <strong>6</strong>
                </div>
            </div>
        </div>
    </article>
    <article class="card">
        <div class="card-title">Maintenance Cost Summary</div>
        @php($totalCost = $workOrders->sum('total_cost'))
        @php($recentCost = $workOrders->where('created_at', '>=', now()->subDays(30))->sum('total_cost'))
        <div class="metric">{{ $totalCost ? '$' . number_format($totalCost, 0) : '-' }}</div>
        <div class="metric-sub">YTD | Last 30 days: {{ $recentCost ? '$' . number_format($recentCost, 0) : '-' }}</div>
        <div class="cost-row"><span>Labor</span><span class="chip">-</span></div>
        <div class="cost-row"><span>Parts</span><span class="chip">-</span></div>
        <div class="cost-row"><span>Contractors</span><span class="chip">-</span></div>
        <div class="cost-row"><span>Fluids</span><span class="chip">-</span></div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Recent Maintenance History</div>
            <div class="card-sub">Last 14 days</div>
        </div>
        <a class="btn btn-ghost" href="/exports/maintenance.pdf">Export</a>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Date</div><div>Asset</div><div>Type</div><div>Downtime</div><div>Cost</div><div>Status</div>
        </div>
        @forelse ($recentOrders as $order)
            <div class="table-row">
                <div>{{ ($order->completed_at ?? $order->created_at)?->format('M d') ?? '-' }}</div>
                <div>{{ $order->asset?->name ?? 'Asset' }}</div>
                <div>{{ ucfirst($order->type ?? 'service') }}</div>
                <div>-</div>
                <div>{{ $order->total_cost ? '$' . number_format($order->total_cost, 0) : '-' }}</div>
                <div><span class="badge {{ $order->status === 'open' ? 'badge-warning' : 'badge-live' }}">{{ ucfirst($order->status) }}</span></div>
            </div>
        @empty
            <div class="table-row">
                <div>No recent maintenance.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>

<section class="kanban">
    <article class="card kanban-column">
        <div class="card-title">Due Soon</div>
        @forelse ($dueSoon as $order)
            <div class="kanban-item">
                <div class="item-title"><a href="/ui/work-orders/{{ $order->id }}">{{ $order->asset?->name ?? 'Asset' }}</a></div>
                <div class="item-sub">{{ $order->description ?? 'Scheduled work' }}</div>
            </div>
        @empty
            <div class="kanban-item">
                <div class="item-title">No upcoming work</div>
                <div class="item-sub">Queue is clear.</div>
            </div>
        @endforelse
    </article>

    <article class="card kanban-column">
        <div class="card-title">In Progress</div>
        @forelse ($inProgress as $order)
            <div class="kanban-item">
                <div class="item-title"><a href="/ui/work-orders/{{ $order->id }}">{{ $order->asset?->name ?? 'Asset' }}</a></div>
                <div class="item-sub">{{ $order->description ?? 'In progress' }}</div>
            </div>
        @empty
            <div class="kanban-item">
                <div class="item-title">No active jobs</div>
                <div class="item-sub">Technicians are available.</div>
            </div>
        @endforelse
    </article>

    <article class="card kanban-column">
        <div class="card-title">Completed</div>
        @forelse ($completed as $order)
            <div class="kanban-item">
                <div class="item-title"><a href="/ui/work-orders/{{ $order->id }}">{{ $order->asset?->name ?? 'Asset' }}</a></div>
                <div class="item-sub">{{ $order->description ?? 'Completed' }}</div>
            </div>
        @empty
            <div class="kanban-item">
                <div class="item-title">No completed work</div>
                <div class="item-sub">Finish a work order to show here.</div>
            </div>
        @endforelse
    </article>
</section>
@endsection



