@extends('ui.layouts.app')
@php($active = 'notifications')

@section('title', 'Notification Details')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Notification</p>
        <h1>Notification {{ $notificationId ?? 'NT-902' }}</h1>
        <p class="sub">Channel delivery status and payload.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/notifications">Back to Notifications</a>
        <button class="btn btn-primary">Resend</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Delivery</div>
        <div class="list">
            <div class="list-item"><span>Channel</span><span class="chip">WhatsApp</span></div>
            <div class="list-item"><span>Recipient</span><span class="chip">+1 555 010</span></div>
            <div class="list-item"><span>Status</span><span class="badge badge-live">Delivered</span></div>
            <div class="list-item"><span>Sent</span><span class="chip">09:14</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Payload</div>
        <div class="list">
            <div class="list-item"><span>Event</span><span class="chip">alarm.triggered</span></div>
            <div class="list-item"><span>Asset</span><span class="chip">Hauler 10</span></div>
            <div class="list-item"><span>Severity</span><span class="chip">Critical</span></div>
        </div>
    </div>
</section>
@endsection


