@extends('ui.layouts.app')
@php($active = 'notifications')

@section('title', 'Notifications')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Comms</p>
        <h1>Notification Channels</h1>
        <p class="sub">WhatsApp, SMS, Telegram, email, and in-app alerts.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Test Channel</button>
        <button class="btn btn-primary">Add Channel</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Channels</div>
        <div class="list">
            <div class="list-item"><span>WhatsApp Business</span><span class="badge badge-live">Enabled</span></div>
            <div class="list-item"><span>SMS Gateway</span><span class="badge">Enabled</span></div>
            <div class="list-item"><span>Telegram Bot</span><span class="badge badge-warning">Paused</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Escalation Ladder</div>
        <div class="card-sub">Alarm acknowledgement flow</div>
        <div class="list">
            <div class="list-item"><span>Level 1</span><span class="chip">Operator + Workshop</span></div>
            <div class="list-item"><span>Level 2</span><span class="chip">Maintenance Manager</span></div>
            <div class="list-item"><span>Level 3</span><span class="chip">GM / Mine Manager</span></div>
        </div>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Recent Notifications</div>
            <div class="card-sub">Delivery status by channel</div>
        </div>
        <div class="chip">Last 24h</div>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Event</div><div>Channel</div><div>Recipient</div><div>Status</div><div>Sent</div><div>Owner</div>
        </div>
        <a class="table-row" href="/ui/notifications/NT-902">
            <div>Alarm Triggered</div><div>WhatsApp</div><div>+1 555 010</div><div><span class="badge badge-live">Delivered</span></div><div>09:14</div><div>Ops Bot</div>
        </a>
        <a class="table-row" href="/ui/notifications/NT-903">
            <div>WO Assigned</div><div>SMS</div><div>+1 555 221</div><div><span class="badge">Sent</span></div><div>08:52</div><div>Ops Bot</div>
        </a>
        <a class="table-row" href="/ui/notifications/NT-904">
            <div>Weekly Report</div><div>Email</div><div>fleet@site</div><div><span class="badge badge-warning">Queued</span></div><div>08:00</div><div>AI Reporter</div>
        </a>
    </div>
</section>
@endsection


