@extends('ui.layouts.app')
@php($active = 'payments')

@section('title', 'Payment Details')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Payment</p>
        <h1>PAY-510 - INV-4481</h1>
        <p class="sub">Invoice settlement, approvals, and remittance.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/payments">Back to Payments</a>
        <button class="btn btn-primary">Mark Paid</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Payment Summary</div>
        <div class="list">
            <div class="list-item"><span>Vendor</span><span class="chip">Summit Industrial</span></div>
            <div class="list-item"><span>Site</span><span class="chip">Quarry</span></div>
            <div class="list-item"><span>Amount</span><span class="chip">$74,200</span></div>
            <div class="list-item"><span>Due Date</span><span class="chip">Aug 30</span></div>
            <div class="list-item"><span>Status</span><span class="badge badge-warning">Scheduled</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Payment Method</div>
        <div class="metric">Bank Transfer</div>
        <div class="metric-sub">Account ending 4412</div>
        <div class="cost-row"><span>Terms</span><span class="chip">Net 14</span></div>
        <div class="cost-row"><span>Reference</span><span class="chip">PO-880</span></div>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Invoice Breakdown</div>
            <div class="card-sub">3 line items</div>
        </div>
        <a class="btn btn-ghost" href="/exports/payments/{{ $paymentId ?? 'PAY-510' }}/pdf">Download Invoice</a>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Item</div><div>Qty</div><div>Unit</div><div>Price</div><div>Total</div><div>Status</div>
        </div>
        <div class="table-row">
            <div>Hydraulic Pump Kit</div><div>2</div><div>pcs</div><div>$14,200</div><div>$28,400</div><div><span class="badge badge-live">Received</span></div>
        </div>
        <div class="table-row">
            <div>Seal Set</div><div>4</div><div>pcs</div><div>$1,200</div><div>$4,800</div><div><span class="badge">Pending</span></div>
        </div>
        <div class="table-row">
            <div>Hydraulic Oil</div><div>12</div><div>L</div><div>$95</div><div>$1,140</div><div><span class="badge">Pending</span></div>
        </div>
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-title">Approval Trail</div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Finance Manager</div>
                    <div class="item-sub">Approved Aug 18</div>
                </div>
                <span class="badge badge-live">Approved</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Procurement Lead</div>
                    <div class="item-sub">Approved Aug 18</div>
                </div>
                <span class="badge badge-live">Approved</span>
            </div>
        </div>
    </article>
    <article class="card">
        <div class="card-title">Remittance</div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Bank ref 230894</div>
                    <div class="item-sub">Scheduled for Aug 29</div>
                </div>
                <span class="badge badge-warning">Pending</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">GRN Match</div>
                    <div class="item-sub">2 items still outstanding</div>
                </div>
                <span class="badge">Open</span>
            </div>
        </div>
    </article>
</section>
@endsection


