@extends('ui.layouts.app')
@php($active = 'pm-schedules')

@section('title', 'PM Schedule Details')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">PM Schedule</p>
        <h1>Schedule {{ $scheduleId ?? 'PM-250' }}</h1>
        <p class="sub">Meter-based preventive maintenance cadence.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/pm-schedules">Back to PM Schedules</a>
        <button class="btn btn-primary">Edit Schedule</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Schedule Profile</div>
        <div class="list">
            <div class="list-item"><span>Asset</span><span class="chip">Excavator 12</span></div>
            <div class="list-item"><span>Interval</span><span class="chip">250 hrs</span></div>
            <div class="list-item"><span>Meter Type</span><span class="chip">Hours</span></div>
            <div class="list-item"><span>Next Due</span><span class="badge badge-warning">2 days</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">History</div>
        <div class="list">
            <div class="list-item"><span>Last Service</span><span class="chip">Dec 12</span></div>
            <div class="list-item"><span>Last Meter</span><span class="chip">2,180 hrs</span></div>
            <div class="list-item"><span>Upcoming Work</span><span class="chip">Filters + Oil</span></div>
        </div>
    </div>
</section>
@endsection


