@extends('ui.layouts.app')
@php($active = 'purchase-orders')

@section('title', 'Purchase Orders')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Supply Chain</p>
        <h1>Purchase Orders</h1>
        <p class="sub">Track approvals, deliveries, and supplier performance.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Dispatch Schedule</button>
        <button class="btn btn-primary">New PO</button>
    </div>
</section>

<section class="grid-3">
    <article class="card">
        <div class="card-title">Open POs</div>
        <div class="metric">24</div>
        <div class="metric-sub">$312k committed</div>
    </article>
    <article class="card">
        <div class="card-title">Delivered</div>
        <div class="metric">18</div>
        <div class="metric-sub">Last 30 days</div>
    </article>
    <article class="card">
        <div class="card-title">On-Time Rate</div>
        <div class="metric">93%</div>
        <div class="metric-sub">Target 95%</div>
    </article>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">PO Value Trend</div>
                <div class="card-sub">Committed spend per week</div>
            </div>
            <div class="chip">Last 10 weeks</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 40%"><span>W1</span></div>
                <div class="chart-bar" style="--value: 52%"><span>W2</span></div>
                <div class="chart-bar" style="--value: 46%"><span>W3</span></div>
                <div class="chart-bar" style="--value: 58%"><span>W4</span></div>
                <div class="chart-bar" style="--value: 62%"><span>W5</span></div>
                <div class="chart-bar" style="--value: 54%"><span>W6</span></div>
                <div class="chart-bar" style="--value: 70%"><span>W7</span></div>
                <div class="chart-bar" style="--value: 66%"><span>W8</span></div>
                <div class="chart-bar" style="--value: 74%"><span>W9</span></div>
                <div class="chart-bar" style="--value: 68%"><span>W10</span></div>
            </div>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Supplier SLA</div>
                <div class="card-sub">On-time delivery by vendor</div>
            </div>
            <div class="chip">This quarter</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 82%"><span>Summit</span></div>
                <div class="chart-bar" style="--value: 68%"><span>Terra Lube</span></div>
                <div class="chart-bar" style="--value: 74%"><span>Prime Spares</span></div>
            </div>
        </div>
    </article>
</section>

<section class="card filters" data-filter-scope>
    <div class="filter-row">
        <input class="input" placeholder="Search POs" data-filter-input />
        <select class="select" data-filter-status>
            <option value="all">Status: All</option>
            <option value="in transit">In Transit</option>
            <option value="awaiting dispatch">Awaiting Dispatch</option>
            <option value="delivered">Delivered</option>
        </select>
        <select class="select" data-filter-site>
            <option value="all">Site: All</option>
            <option value="quarry">Quarry</option>
            <option value="workshop">Workshop</option>
            <option value="concrete plant">Concrete Plant</option>
        </select>
        <button class="btn btn-ghost" type="button" data-export-button data-export-type="purchase-orders">Export Selected</button>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Active Purchase Orders</div>
            <div class="card-sub">Awaiting delivery or closeout</div>
        </div>
        <div class="chip">Updated 20m ago</div>
    </div>
    <div class="table">
        <div class="table-row table-head table-row-7">
            <div></div><div>PO</div><div>Vendor</div><div>Site</div><div>Value</div><div>ETA</div><div>Status</div>
        </div>
        <div class="table-row table-row-7" data-row data-row-id="PO-880" data-status="in transit" data-site="quarry" data-search="po-880 summit industrial quarry 74200 aug 24 in transit">
            <div class="table-select"><input type="checkbox" data-row-select value="PO-880" /></div>
            <div><a href="/ui/purchase-orders/PO-880">PO-880</a></div><div>Summit Industrial</div><div>Quarry</div><div>$74,200</div><div>Aug 24</div><div><span class="badge badge-warning">In Transit</span></div>
        </div>
        <div class="table-row table-row-7" data-row data-row-id="PO-882" data-status="awaiting dispatch" data-site="workshop" data-search="po-882 prime spares workshop 18600 aug 28 awaiting dispatch">
            <div class="table-select"><input type="checkbox" data-row-select value="PO-882" /></div>
            <div><a href="/ui/purchase-orders/PO-882">PO-882</a></div><div>Prime Spares</div><div>Workshop</div><div>$18,600</div><div>Aug 28</div><div><span class="badge">Awaiting Dispatch</span></div>
        </div>
        <div class="table-row table-row-7" data-row data-row-id="PO-886" data-status="delivered" data-site="concrete plant" data-search="po-886 terra lube concrete plant 9840 aug 20 delivered">
            <div class="table-select"><input type="checkbox" data-row-select value="PO-886" /></div>
            <div><a href="/ui/purchase-orders/PO-886">PO-886</a></div><div>Terra Lube</div><div>Concrete Plant</div><div>$9,840</div><div>Aug 20</div><div><span class="badge badge-live">Delivered</span></div>
        </div>
    </div>
</section>
@endsection


