@extends('ui.layouts.app')
@php($active = 'purchase-requests')
@php($request = \App\Models\PurchaseRequest::with(['items.documents', 'site'])->where('id', $requestId)->orWhere('request_code', $requestId)->first())
@php($items = $request ? $request->items : collect())

@section('title', 'Purchase Request Details')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Purchase Request</p>
        <h1>{{ $request?->request_code ?? 'PR' }} - {{ $request?->title ?? 'Procurement Request' }}</h1>
        <p class="sub">Request details, approvals, and sourcing notes.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/purchase-requests">Back to Requests</a>
        @if ($request)
            <a class="btn btn-ghost" href="/exports/purchase-requests/{{ $request->id }}/pdf">Download PDF</a>
            <a class="btn btn-ghost" href="/exports/purchase-requests/{{ $request->id }}/excel">Download Excel</a>
        @endif
        <button class="btn btn-primary">Convert to PO</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Request Summary</div>
        <div class="list">
            <div class="list-item"><span>Site</span><span class="chip">{{ $request?->site?->name ?? 'Unassigned' }}</span></div>
            <div class="list-item"><span>Category</span><span class="chip">{{ $request?->title ?? 'Procurement' }}</span></div>
            <div class="list-item"><span>Requested By</span><span class="chip">{{ $request?->requested_by ? 'User ' . $request->requested_by : 'System Import' }}</span></div>
            <div class="list-item"><span>Priority</span><span class="badge badge-warning">{{ ucfirst($request?->priority ?? 'medium') }}</span></div>
            <div class="list-item"><span>Status</span><span class="badge">{{ ucfirst($request?->status ?? 'pending') }}</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Budget Impact</div>
        <div class="metric">{{ $request?->total_estimated_cost !== null ? '$' . number_format($request->total_estimated_cost, 0) : '-' }}</div>
        <div class="metric-sub">Budget remaining: $120,000</div>
        <div class="cost-row"><span>Parts</span><span class="chip">$22,900</span></div>
        <div class="cost-row"><span>Logistics</span><span class="chip">$3,200</span></div>
        <div class="cost-row"><span>Contingency</span><span class="chip">$2,300</span></div>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Requested Items</div>
            <div class="card-sub">{{ $items->count() }} line items</div>
        </div>
        <button class="btn btn-ghost">Add Item</button>
    </div>
    <div class="table">
        <div class="table-row table-head table-row-7-no-select">
            <div>Item</div><div>Qty</div><div>Unit</div><div>Est. Cost</div><div>Supplier</div><div>Status</div><div>Actions</div>
        </div>
        @forelse ($items as $item)
            @php($quoted = $item->quote_amount_usd || $item->quote_amount_zwl)
            <div class="table-row table-row-7-no-select"
                data-pr-item
                data-item-id="{{ $item->id }}"
                data-item-name="{{ $item->item_name }}"
                data-item-qty="{{ $item->quantity }}"
                data-item-unit="{{ $item->unit }}"
                data-item-purpose="{{ $item->purpose_cost_center }}"
                data-item-supplier="{{ $item->supplier_name }}"
                data-item-selected="{{ $item->selected_supplier }}"
                data-item-usd="{{ $item->quote_amount_usd }}"
                data-item-zwl="{{ $item->quote_amount_zwl }}"
                data-item-comments="{{ $item->comments }}"
            >
                <div>{{ $item->item_name ?? 'Item' }}</div>
                <div>{{ $item->quantity !== null ? number_format($item->quantity, 0) : '-' }}</div>
                <div>{{ $item->unit ?? '-' }}</div>
                <div>
                    @if ($item->quote_amount_usd !== null)
                        ${{ number_format($item->quote_amount_usd, 0) }}
                    @elseif ($item->quote_amount_zwl !== null)
                        ZWL {{ number_format($item->quote_amount_zwl, 0) }}
                    @else
                        -
                    @endif
                </div>
                <div>{{ $item->selected_supplier ?? $item->supplier_name ?? '-' }}</div>
                <div><span class="badge {{ $quoted ? 'badge-live' : 'badge' }}">{{ $quoted ? 'Quoted' : 'Pending' }}</span></div>
                <div class="table-actions">
                    <button class="btn btn-ghost btn-sm" type="button" data-pr-item-view="{{ $item->id }}">View</button>
                    <button class="btn btn-ghost btn-sm" type="button" data-pr-item-edit="{{ $item->id }}">Edit</button>
                    <button class="btn btn-ghost btn-sm" type="button" data-pr-item-attach="{{ $item->id }}">Attach</button>
                </div>
            </div>
            <div class="pr-item-details" data-pr-item-details="{{ $item->id }}" hidden>
                <div class="pr-item-details-card">
                    <div>
                        <div class="card-title">Line Item Details</div>
                        <div class="card-sub">{{ $item->purpose_cost_center ?? 'No cost center' }}</div>
                    </div>
                    <div class="pr-item-docs">
                        <div class="card-title">Attachments</div>
                        <ul class="pr-doc-list" data-pr-doc-list="{{ $item->id }}">
                            @forelse ($item->documents as $doc)
                                <li><a href="{{ route('purchase-request-item-documents.download', [$item->id, $doc->id]) }}">{{ $doc->original_name }}</a></li>
                            @empty
                                <li>No attachments yet.</li>
                            @endforelse
                        </ul>
                    </div>
                </div>
            </div>
        @empty
            <div class="table-row table-row-7-no-select">
                <div>No items found.</div><div></div><div></div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-title">Approvals</div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Maintenance Manager</div>
                    <div class="item-sub">Awaiting approval</div>
                </div>
                <span class="badge badge-warning">Pending</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Finance</div>
                    <div class="item-sub">Auto-approval required</div>
                </div>
                <span class="badge">Not started</span>
            </div>
        </div>
    </article>
    <article class="card">
        <div class="card-title">Sourcing Notes</div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Lead time 5 days</div>
                    <div class="item-sub">Priority shipping recommended</div>
                </div>
                <span class="badge badge-live">On Track</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Budget variance</div>
                    <div class="item-sub">+4% vs last quarter average</div>
                </div>
                <span class="badge badge-warning">Review</span>
            </div>
        </div>
    </article>
</section>
@endsection


