@extends('ui.layouts.app')
@php($active = 'purchase-requests')
@php($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first())
@php($requests = $tenant ? \App\Models\PurchaseRequest::with('site')->where('tenant_id', $tenant->id)->orderByDesc('created_at')->get() : collect())
@php($statusOptions = $requests->pluck('status')->filter()->unique()->values())
@php($siteOptions = $requests->map(fn ($request) => $request->site?->name)->filter()->unique()->values())
@php($pendingCount = $requests->whereIn('status', ['pending', 'awaiting', 'submitted'])->count())
@php($approvedThisWeek = $requests->where('status', 'approved')->filter(fn ($request) => $request->created_at && $request->created_at->greaterThanOrEqualTo(now()->subDays(7)))->count())
@php($avgCycle = $requests->where('status', 'approved')->map(fn ($request) => $request->updated_at && $request->created_at ? $request->updated_at->diffInDays($request->created_at) : null)->filter()->avg())

@section('title', 'Purchase Requests')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Supply Chain</p>
        <h1>Purchase Requests</h1>
        <p class="sub">Capture demand, route approvals, and track spend intent.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Approval Queue</button>
        <button class="btn btn-primary">New Request</button>
    </div>
</section>

<section class="grid-3">
    <article class="card">
        <div class="card-title">Pending Approval</div>
        <div class="metric">{{ $pendingCount }}</div>
        <div class="metric-sub">Awaiting manager sign-off</div>
    </article>
    <article class="card">
        <div class="card-title">Approved This Week</div>
        <div class="metric">{{ $approvedThisWeek }}</div>
        <div class="metric-sub">${{ number_format($requests->where('status', 'approved')->sum('total_estimated_cost'), 0) }} total value</div>
    </article>
    <article class="card">
        <div class="card-title">Avg Cycle Time</div>
        <div class="metric">{{ $avgCycle ? number_format($avgCycle, 1) : '0.0' }} days</div>
        <div class="metric-sub">Request to approval</div>
    </article>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Request Volume</div>
                <div class="card-sub">Last 8 weeks</div>
            </div>
            <div class="chip">Trend</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 42%"><span>W1</span></div>
                <div class="chart-bar" style="--value: 48%"><span>W2</span></div>
                <div class="chart-bar" style="--value: 56%"><span>W3</span></div>
                <div class="chart-bar" style="--value: 52%"><span>W4</span></div>
                <div class="chart-bar" style="--value: 62%"><span>W5</span></div>
                <div class="chart-bar" style="--value: 58%"><span>W6</span></div>
                <div class="chart-bar" style="--value: 70%"><span>W7</span></div>
                <div class="chart-bar" style="--value: 64%"><span>W8</span></div>
            </div>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Top Categories</div>
                <div class="card-sub">By value</div>
            </div>
            <div class="chip">Month to date</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 78%"><span>Parts</span></div>
                <div class="chart-bar" style="--value: 62%"><span>Tyres</span></div>
                <div class="chart-bar" style="--value: 48%"><span>Fuel</span></div>
                <div class="chart-bar" style="--value: 36%"><span>Contractors</span></div>
            </div>
        </div>
    </article>
</section>

<section class="card filters" data-filter-scope>
    <div class="filter-row">
        <input class="input" placeholder="Search requests" data-filter-input />
        <select class="select" data-filter-status>
            <option value="all">Status: All</option>
            @foreach ($statusOptions as $status)
                <option value="{{ strtolower($status) }}">{{ ucfirst($status) }}</option>
            @endforeach
        </select>
        <select class="select" data-filter-site>
            <option value="all">Site: All</option>
            @foreach ($siteOptions as $site)
                <option value="{{ strtolower($site) }}">{{ $site }}</option>
            @endforeach
        </select>
        <button class="btn btn-ghost" type="button" data-export-button data-export-type="purchase-requests">Export Selected</button>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Open Requests</div>
            <div class="card-sub">Awaiting approval or conversion</div>
        </div>
        <div class="chip">Updated 15m ago</div>
    </div>
    <div class="table">
        <div class="table-row table-head table-row-7">
            <div></div><div>ID</div><div>Site</div><div>Category</div><div>Amount</div><div>Priority</div><div>Status</div>
        </div>
        @forelse ($requests as $request)
            @php($status = strtolower($request->status ?? 'pending'))
            @php($badge = $status === 'approved' ? 'badge-live' : ($status === 'pending' || $status === 'awaiting' ? 'badge-warning' : 'badge'))
            <div class="table-row table-row-7" data-row data-row-id="{{ $request->id }}" data-status="{{ $status }}" data-site="{{ strtolower($request->site?->name ?? 'unassigned') }}" data-search="{{ strtolower($request->request_code . ' ' . ($request->site?->name ?? '') . ' ' . ($request->title ?? '') . ' ' . ($request->priority ?? '') . ' ' . $status) }}">
                <div class="table-select">
                    <input type="checkbox" data-row-select value="{{ $request->id }}" />
                </div>
                <div><a href="/ui/purchase-requests/{{ $request->id }}">{{ $request->request_code }}</a></div>
                <div>{{ $request->site?->name ?? 'Unassigned' }}</div>
                <div>{{ $request->title ?? 'Procurement' }}</div>
                <div>{{ $request->total_estimated_cost !== null ? '$' . number_format($request->total_estimated_cost, 0) : '-' }}</div>
                <div>{{ ucfirst($request->priority ?? 'medium') }}</div>
                <div><span class="badge {{ $badge }}">{{ ucfirst($status) }}</span></div>
            </div>
        @empty
            <div class="table-row table-row-7">
                <div></div><div>No purchase requests found.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-title">Approval Queue</div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">PR-410 - Hydraulic kit</div>
                    <div class="item-sub">Awaiting Maintenance Manager</div>
                </div>
                <span class="badge badge-warning">Escalate</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">PR-412 - Concrete admixtures</div>
                    <div class="item-sub">Finance review</div>
                </div>
                <span class="badge">In review</span>
            </div>
        </div>
    </article>
    <article class="card">
        <div class="card-title">Auto-Generated Suggestions</div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Reorder filters</div>
                    <div class="item-sub">Min stock breached at Workshop</div>
                </div>
                <span class="badge badge-ai">AI</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Order tyres for Hauler H-44</div>
                    <div class="item-sub">Tread depth below threshold</div>
                </div>
                <span class="badge badge-warning">Action</span>
            </div>
        </div>
    </article>
</section>
@endsection


