@extends('ui.layouts.app')
@php($active = 'reconciliation')
@php($suggestedCount = $rows->filter(fn ($row) => ($row['link']->status ?? 'suggested') === 'suggested')->count())
@php($appliedCount = $rows->filter(fn ($row) => ($row['link']->status ?? '') === 'applied')->count())
@php($ignoredCount = $rows->filter(fn ($row) => ($row['link']->status ?? '') === 'ignored')->count())

@section('title', 'Reconciliation')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Admin</p>
        <h1>Linking &amp; Reconciliation</h1>
        <p class="sub">Detect and resolve missing links between PRs, POs, GRNs, invoices, and PM work.</p>
    </div>
    <div class="page-actions">
        <form method="POST" action="/ui/reconciliation/run">
            @csrf
            <button class="btn btn-ghost" type="submit">Run Engine</button>
        </form>
    </div>
</section>

<section class="grid-3">
    <article class="card">
        <div class="card-title">Suggested Links</div>
        <div class="metric">{{ $suggestedCount }}</div>
        <div class="metric-sub">Awaiting confirmation</div>
    </article>
    <article class="card">
        <div class="card-title">Applied Links</div>
        <div class="metric">{{ $appliedCount }}</div>
        <div class="metric-sub">Auto-applied or confirmed</div>
    </article>
    <article class="card">
        <div class="card-title">Ignored Links</div>
        <div class="metric">{{ $ignoredCount }}</div>
        <div class="metric-sub">Dismissed suggestions</div>
    </article>
</section>

<section class="card filters" data-filter-scope>
    <div class="filter-row">
        <input class="input" placeholder="Search links" data-filter-input />
        <select class="select" data-filter-status>
            <option value="all">Status: All</option>
            @foreach ($statusOptions as $status)
                <option value="{{ strtolower($status) }}">{{ ucfirst($status) }}</option>
            @endforeach
        </select>
        <select class="select" data-filter-site>
            <option value="all">Link Type: All</option>
            @foreach ($typeOptions as $type)
                <option value="{{ $type['value'] }}">{{ $type['label'] }}</option>
            @endforeach
        </select>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Reconciliation Queue</div>
            <div class="card-sub">Review and apply safe matches</div>
        </div>
        <div class="chip">Last 200</div>
    </div>
    <div class="table">
        <div class="table-row table-head table-row-7-no-select">
            <div>Type</div><div>Source</div><div>Target</div><div>Confidence</div><div>Status</div><div>Reason</div><div>Action</div>
        </div>
        @forelse ($rows as $row)
            @php($link = $row['link'])
            @php($status = strtolower($link->status ?? 'suggested'))
            @php($badge = $status === 'applied' ? 'badge-live' : ($status === 'suggested' ? 'badge-warning' : 'badge'))
            @php($search = strtolower(trim($row['type_label'] . ' ' . $row['source_label'] . ' ' . $row['target_label'] . ' ' . ($link->reason ?? '') . ' ' . $status)))
            <div class="table-row table-row-7-no-select" data-row data-row-id="{{ $link->id }}" data-status="{{ $status }}" data-site="{{ $row['type_value'] }}" data-search="{{ $search }}">
                <div>{{ $row['type_label'] }}</div>
                <div>
                    @if ($row['source_path'])
                        <a href="{{ $row['source_path'] }}">{{ $row['source_label'] }}</a>
                    @else
                        {{ $row['source_label'] }}
                    @endif
                </div>
                <div>
                    @if ($row['target_path'])
                        <a href="{{ $row['target_path'] }}">{{ $row['target_label'] }}</a>
                    @else
                        {{ $row['target_label'] }}
                    @endif
                </div>
                <div><span class="chip">{{ $link->confidence ? number_format($link->confidence * 100, 0) . '%' : '-' }}</span></div>
                <div><span class="badge {{ $badge }}">{{ ucfirst($status) }}</span></div>
                <div>{{ $link->reason ?? '-' }}</div>
                <div class="table-actions">
                    @if ($status === 'suggested')
                        <form method="POST" action="/ui/reconciliation/{{ $link->id }}/apply">
                            @csrf
                            <button class="btn btn-primary" type="submit">Apply</button>
                        </form>
                        <form method="POST" action="/ui/reconciliation/{{ $link->id }}/ignore">
                            @csrf
                            <button class="btn btn-ghost" type="submit">Ignore</button>
                        </form>
                    @else
                        <span class="chip">{{ ucfirst($status) }}</span>
                    @endif
                </div>
            </div>
        @empty
            <div class="table-row table-row-7-no-select">
                <div>No reconciliation links yet.</div><div></div><div></div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>
@endsection
