@extends('ui.layouts.app')
@php($active = 'reports')

@section('title', 'Report Details')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Report</p>
        <h1>Report {{ $reportId ?? 'Weekly Operations' }}</h1>
        <p class="sub">Auto-generated KPI narrative with action items.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/reports">Back to Reports</a>
        <a class="btn btn-primary" href="/exports/reports/{{ urlencode($reportId ?? 'Weekly Operations') }}/pdf">Download PDF</a>
    </div>
</section>

<section class="card">
    <div class="card-title">Executive Summary</div>
    <p class="sub">Availability is stable at 92%, with downtime driven by waiting parts on loaders. Fuel variance improved by 1.2% week over week.</p>
    <div class="list">
        <div class="list-item"><span>Top Downtime Reason</span><span class="chip">Waiting Parts</span></div>
        <div class="list-item"><span>Cost Driver</span><span class="chip">Hydraulic components</span></div>
        <div class="list-item"><span>Next Actions</span><span class="chip">Reorder filters, close WO-221</span></div>
    </div>
</section>
@endsection


