@extends('ui.layouts.app')
@php($active = 'reports')

@section('title', 'Reports')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Reports</p>
        <h1>Operational Reports</h1>
        <p class="sub">Generate compliance-ready summaries and exports.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Schedule</button>
        <button class="btn btn-primary">Generate Report</button>
    </div>
</section>

<section class="grid-3">
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/reports/Weekly%20Operations">Weekly Operations</a></div>
        <div class="kpi-value">94.8%</div>
        <div class="kpi-meta">Fleet availability</div>
    </article>
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/reports/Cost%20Drivers">Cost Drivers</a></div>
        <div class="kpi-value">$214k</div>
        <div class="kpi-meta">Maintenance spend this month</div>
    </article>
    <article class="card kpi">
        <div class="kpi-label"><a href="/ui/reports/Compliance%20Checklist">Compliance Checklist</a></div>
        <div class="kpi-value">98%</div>
        <div class="kpi-meta">Audit readiness</div>
    </article>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Report Downloads</div>
                <div class="card-sub">Export reports as PDF or presentation</div>
            </div>
        </div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Weekly Operations</div>
                    <div class="item-sub">Last generated 2 days ago</div>
                </div>
                <div class="page-actions">
                    <a class="btn btn-ghost" href="/ui/reports/Weekly%20Operations">Preview</a>
                    <a class="btn btn-ghost" href="/exports/reports/Weekly%20Operations/pdf">Download PDF</a>
                    <a class="btn btn-ghost" href="/exports/reports/Weekly%20Operations/ppt">Download PPT</a>
                </div>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Maintenance Digest</div>
                    <div class="item-sub">Updated 6 hours ago</div>
                </div>
                <div class="page-actions">
                    <a class="btn btn-ghost" href="/ui/reports/Maintenance%20Digest">Preview</a>
                    <a class="btn btn-ghost" href="/exports/reports/Maintenance%20Digest/pdf">Download PDF</a>
                    <a class="btn btn-ghost" href="/exports/reports/Maintenance%20Digest/ppt">Download PPT</a>
                </div>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Compliance Checklist</div>
                    <div class="item-sub">Updated hourly</div>
                </div>
                <div class="page-actions">
                    <a class="btn btn-ghost" href="/ui/reports/Compliance%20Checklist">Preview</a>
                    <a class="btn btn-ghost" href="/exports/reports/Compliance%20Checklist/pdf">Download PDF</a>
                    <a class="btn btn-ghost" href="/exports/reports/Compliance%20Checklist/ppt">Download PPT</a>
                </div>
            </div>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">AI Analytics Summary</div>
                <div class="card-sub">Auto-generated insights from fleet data</div>
            </div>
            <span class="badge badge-ai">AI</span>
        </div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Downtime spike detected</div>
                    <div class="item-sub">Crushing Plant downtime up 12% week-on-week</div>
                </div>
                <span class="badge badge-warning">Action</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Fuel burn anomaly</div>
                    <div class="item-sub">Hauler H-44 consuming 18% above baseline</div>
                </div>
                <span class="badge">Watch</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">PM compliance risk</div>
                    <div class="item-sub">6 PMs projected overdue in 10 days</div>
                </div>
                <span class="badge badge-warning">Risk</span>
            </div>
        </div>
    </article>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Availability Trend</div>
                <div class="card-sub">Fleet availability last 12 weeks</div>
            </div>
            <div class="chip">Avg 94.8%</div>
        </div>
        <div class="trend-chart">
            <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                <path class="trend-fill" d="M0 86 L40 80 L80 74 L120 68 L160 62 L200 58 L240 52 L260 46 L260 120 L0 120 Z"></path>
                <polyline class="trend-line" points="0,86 40,80 80,74 120,68 160,62 200,58 240,52 260,46"></polyline>
                <circle class="trend-dot" cx="80" cy="74" r="3"></circle>
                <circle class="trend-dot" cx="160" cy="62" r="3"></circle>
                <circle class="trend-dot" cx="260" cy="46" r="3"></circle>
            </svg>
        </div>
        <div class="trend-legend">
            <span>Downtime 6.2h</span>
            <span>Reliability 96.1%</span>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Cost Composition</div>
                <div class="card-sub">Maintenance cost split</div>
            </div>
            <div class="chip">Month to date</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 72%"><span>Parts</span></div>
                <div class="chart-bar" style="--value: 58%"><span>Labor</span></div>
                <div class="chart-bar" style="--value: 34%"><span>Contractors</span></div>
                <div class="chart-bar" style="--value: 22%"><span>Fuel</span></div>
            </div>
        </div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Operational Highlights</div>
            <div class="card-sub">Key visuals and snapshots</div>
        </div>
        <a class="btn btn-ghost" href="/exports/reports/pack/pdf">Download Pack</a>
    </div>
    <div class="grid-3">
        <article class="card">
            <div class="card-title">Quarry Utilization</div>
            <div class="map-placeholder">
                <img class="map-overlay" src="/ui-assets/images/map-grid.svg" alt="" aria-hidden="true">
                <div class="map-label">Quarry Zone A</div>
            </div>
        </article>
        <article class="card">
            <div class="card-title">Work Order Heatmap</div>
            <div class="chart-placeholder chart-placeholder--bars">
                <div class="chart-bars">
                    <div class="chart-bar" style="--value: 44%"><span>Mon</span></div>
                    <div class="chart-bar" style="--value: 58%"><span>Tue</span></div>
                    <div class="chart-bar" style="--value: 70%"><span>Wed</span></div>
                    <div class="chart-bar" style="--value: 52%"><span>Thu</span></div>
                    <div class="chart-bar" style="--value: 36%"><span>Fri</span></div>
                </div>
            </div>
        </article>
        <article class="card">
            <div class="card-title">Fuel Efficiency Snapshot</div>
            <div class="trend-chart">
                <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                    <path class="trend-fill" d="M0 78 L40 72 L80 68 L120 62 L160 66 L200 58 L240 54 L260 50 L260 120 L0 120 Z"></path>
                    <polyline class="trend-line" points="0,78 40,72 80,68 120,62 160,66 200,58 240,54 260,50"></polyline>
                    <circle class="trend-dot" cx="120" cy="62" r="3"></circle>
                    <circle class="trend-dot" cx="200" cy="58" r="3"></circle>
                    <circle class="trend-dot" cx="260" cy="50" r="3"></circle>
                </svg>
            </div>
            <div class="trend-legend">
                <span>Avg 14.7 L/hr</span>
                <span>Best 12.8 L/hr</span>
            </div>
        </article>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Report Library</div>
            <div class="card-sub">Saved and scheduled reports</div>
        </div>
        <button class="btn btn-ghost">Manage</button>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Report</div><div>Owner</div><div>Frequency</div><div>Last Run</div><div>Format</div><div>Action</div>
        </div>
        <div class="table-row">
            <div>Weekly Operations</div><div>Ops Lead</div><div>Weekly</div><div>2 days ago</div><div>PDF, PPT</div><div><a class="btn btn-ghost" href="/ui/reports/Weekly%20Operations">Preview</a></div>
        </div>
        <div class="table-row">
            <div>Maintenance Digest</div><div>Maintenance</div><div>Weekly</div><div>6 hours ago</div><div>PDF</div><div><a class="btn btn-ghost" href="/ui/reports/Maintenance%20Digest">Preview</a></div>
        </div>
        <div class="table-row">
            <div>Compliance Checklist</div><div>Safety</div><div>Daily</div><div>1 hour ago</div><div>PDF</div><div><a class="btn btn-ghost" href="/ui/reports/Compliance%20Checklist">Preview</a></div>
        </div>
    </div>
</section>
@endsection


