@extends('ui.layouts.app')
@php($active = 'roles')

@section('title', 'Role Details')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Role</p>
        <h1>Role {{ $roleId ?? 'Admin' }}</h1>
        <p class="sub">Access scope and assigned users.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/roles">Back to Roles</a>
        <button class="btn btn-primary">Edit Role</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Role Profile</div>
        <div class="list">
            <div class="list-item"><span>Scope</span><span class="chip">Full Access</span></div>
            <div class="list-item"><span>Users</span><span class="chip">3</span></div>
            <div class="list-item"><span>Default</span><span class="badge badge-live">Yes</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Permissions</div>
        <div class="list">
            <div class="list-item"><span>Assets</span><span class="chip">Manage</span></div>
            <div class="list-item"><span>Work Orders</span><span class="chip">Approve</span></div>
            <div class="list-item"><span>Reports</span><span class="chip">Export</span></div>
        </div>
    </div>
</section>
@endsection


