@extends('ui.layouts.app')
@php($active = 'sites')

@section('title', 'Sites')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Locations</p>
        <h1>Sites & Locations</h1>
        <p class="sub">Manage quarries, plants, workshops, and client sites.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/exports/sites.pdf">Export</a>
        <button class="btn btn-primary">Add Site</button>
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Site Utilization</div>
                <div class="card-sub">Utilization by location</div>
            </div>
            <div class="chip">Current month</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 88%"><span>Quarry</span></div>
                <div class="chart-bar" style="--value: 72%"><span>Crushing</span></div>
                <div class="chart-bar" style="--value: 64%"><span>Concrete</span></div>
                <div class="chart-bar" style="--value: 52%"><span>Workshop</span></div>
            </div>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Availability Trend</div>
                <div class="card-sub">All sites combined</div>
            </div>
            <div class="chip">Last 10 weeks</div>
        </div>
        <div class="trend-chart">
            <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                <path class="trend-fill" d="M0 86 L40 80 L80 74 L120 70 L160 66 L200 60 L240 56 L260 52 L260 120 L0 120 Z"></path>
                <polyline class="trend-line" points="0,86 40,80 80,74 120,70 160,66 200,60 240,56 260,52"></polyline>
                <circle class="trend-dot" cx="80" cy="74" r="3"></circle>
                <circle class="trend-dot" cx="160" cy="66" r="3"></circle>
                <circle class="trend-dot" cx="260" cy="52" r="3"></circle>
            </svg>
        </div>
        <div class="trend-legend">
            <span>Availability 91-96%</span>
            <span>Outages 4</span>
        </div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Active Sites</div>
            <div class="card-sub">Operational footprint across projects</div>
        </div>
        <div class="chip">Updated today</div>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Name</div><div>Type</div><div>Manager</div><div>Status</div><div>Assets</div><div>Notes</div>
        </div>
        <a class="table-row" href="/ui/sites/S-101">
            <div>Quarry North Ridge</div><div>Quarry</div><div>Ella Ford</div><div><span class="badge badge-live">Active</span></div><div>84</div><div>High utilization</div>
        </a>
        <a class="table-row" href="/ui/sites/S-102">
            <div>Plant A</div><div>Processing</div><div>Hassan Ali</div><div><span class="badge">Monitoring</span></div><div>42</div><div>Shifted to night ops</div>
        </a>
        <a class="table-row" href="/ui/sites/S-103">
            <div>Central Workshop</div><div>Workshop</div><div>Maria Lee</div><div><span class="badge badge-ai">AI Assist</span></div><div>18</div><div>Backlog reduced</div>
        </a>
    </div>
</section>
@endsection


