@extends('ui.layouts.app')
@php($active = 'telemetry')

@section('title', 'Telemetry Details')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Telemetry</p>
        <h1>Stream {{ $telemetryId ?? 'TM-884' }}</h1>
        <p class="sub">Raw events, normalized metrics, and alerts.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/telemetry">Back to Telemetry</a>
        <a class="btn btn-primary" href="/exports/telemetry/{{ $telemetryId ?? 'TM-880' }}/pdf">Export</a>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Latest Metrics</div>
        <div class="list">
            <div class="list-item"><span>Engine Temp</span><span class="chip">86 C</span></div>
            <div class="list-item"><span>Vibration</span><span class="chip">0.92 g</span></div>
            <div class="list-item"><span>Fuel Rate</span><span class="chip">56 L/hr</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Raw Event</div>
        <div class="list">
            <div class="list-item"><span>Device</span><span class="chip">DEV-102Q</span></div>
            <div class="list-item"><span>Payload Size</span><span class="chip">4.2 KB</span></div>
            <div class="list-item"><span>Received</span><span class="chip">2m ago</span></div>
        </div>
    </div>
</section>
@endsection


