@extends('ui.layouts.app')
@php($active = 'telemetry')
@php($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first())
@php($latestTelemetry = $tenant ? \App\Models\Telemetry::where('tenant_id', $tenant->id)->latest()->first() : null)
@php($telemetryData = $latestTelemetry?->data ?? [])

@section('title', 'Telemetry')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Telemetry</p>
        <h1>Sensor Pulse</h1>
        <p class="sub">Monitor live streams, anomalies, and efficiency drift.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Configure Streams</button>
        <button class="btn btn-primary">Add Sensor</button>
    </div>
</section>

<section class="grid-3">
    <article class="card">
        <div class="card-title"><a href="/ui/telemetry/TM-880">Vibration</a></div>
        <div class="metric">{{ $telemetryData['vibration'] ?? '0.92' }} g</div>
        <div class="metric-sub">Within tolerance</div>
    </article>
    <article class="card">
        <div class="card-title"><a href="/ui/telemetry/TM-881">Engine Temp</a></div>
        <div class="metric">{{ $telemetryData['engine_temp'] ?? 84 }} C</div>
        <div class="metric-sub">Stable</div>
    </article>
    <article class="card">
        <div class="card-title"><a href="/ui/telemetry/TM-882">Fuel Flow</a></div>
        <div class="metric">{{ $telemetryData['fuel_rate'] ?? 56 }} L/hr</div>
        <div class="metric-sub">Optimized</div>
    </article>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Sensor Uptime Trend</div>
                <div class="card-sub">Last 14 days</div>
            </div>
            <div class="chip">98% avg</div>
        </div>
        <div class="trend-chart">
            <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                <path class="trend-fill" d="M0 82 L40 78 L80 74 L120 70 L160 66 L200 62 L240 58 L260 54 L260 120 L0 120 Z"></path>
                <polyline class="trend-line" points="0,82 40,78 80,74 120,70 160,66 200,62 240,58 260,54"></polyline>
                <circle class="trend-dot" cx="80" cy="74" r="3"></circle>
                <circle class="trend-dot" cx="160" cy="66" r="3"></circle>
                <circle class="trend-dot" cx="260" cy="54" r="3"></circle>
            </svg>
        </div>
        <div class="trend-legend">
            <span>Uptime 96-99%</span>
            <span>Dropouts 3</span>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Alert Rate</div>
                <div class="card-sub">Anomalies per day</div>
            </div>
            <div class="chip">This week</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 32%"><span>Mon</span></div>
                <div class="chart-bar" style="--value: 44%"><span>Tue</span></div>
                <div class="chart-bar" style="--value: 28%"><span>Wed</span></div>
                <div class="chart-bar" style="--value: 54%"><span>Thu</span></div>
                <div class="chart-bar" style="--value: 38%"><span>Fri</span></div>
                <div class="chart-bar" style="--value: 26%"><span>Sat</span></div>
                <div class="chart-bar" style="--value: 20%"><span>Sun</span></div>
            </div>
        </div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Live Streams</div>
            <div class="card-sub">Last 15 minutes</div>
        </div>
        <div class="chip">Streaming</div>
    </div>
    <div class="chart-placeholder">Telemetry Chart</div>
</section>
@endsection



