@extends('ui.layouts.app')
@php($active = 'tenants')

@section('title', 'Tenants')

@php($tenants = \App\Models\Tenant::withCount(['assets', 'users'])->orderBy('name')->get())

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Tenants</p>
        <h1>Tenant Directory</h1>
        <p class="sub">Multi-tenant management and provisioning.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Invite Tenant</button>
        <button class="btn btn-primary">Create Tenant</button>
    </div>
</section>

<section class="card">
    <div class="table">
        <div class="table-row table-head">
            <div>Tenant</div><div>Plan</div><div>Assets</div><div>Users</div><div>Status</div>
        </div>
        @forelse ($tenants as $tenant)
            @php($status = strtolower($tenant->status ?? 'active'))
            @php($badge = $status === 'active' ? 'badge-live' : ($status === 'trial' ? 'badge-warning' : 'badge'))
            <a class="table-row" href="/ui/tenants/{{ $tenant->id }}">
                <div>{{ $tenant->name }}</div>
                <div>{{ $tenant->subscription_plan ?? 'Enterprise' }}</div>
                <div>{{ $tenant->assets_count ?? 0 }}</div>
                <div>{{ $tenant->users_count ?? 0 }}</div>
                <div><span class="badge {{ $badge }}">{{ ucfirst($status) }}</span></div>
            </a>
        @empty
            <div class="table-row">
                <div>No tenants found.</div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>
@endsection


