@extends('ui.layouts.app')
@php($active = 'users')
@php($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::first())
@php($users = $tenant ? \App\Models\User::with(['roles', 'site'])->where('tenant_id', $tenant->id)->orderBy('name')->get() : collect())

@section('title', 'Users')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Users</p>
        <h1>Team Access</h1>
        <p class="sub">Manage roles, permissions, and shift coverage.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Sync HRIS</button>
        <button class="btn btn-primary">Invite User</button>
    </div>
</section>

<section class="card">
    <div class="table">
        <div class="table-row table-head">
            <div>Name</div><div>Role</div><div>Site</div><div>Status</div><div>Last Active</div>
        </div>
        @forelse ($users as $user)
            <a class="table-row" href="/ui/users/{{ $user->id }}">
                <div>{{ $user->name }}</div>
                <div>{{ $user->roles->pluck('name')->implode(', ') ?: 'User' }}</div>
                <div>{{ $user->site?->name ?? 'All Sites' }}</div>
                <div><span class="badge badge-live">Active</span></div>
                <div>{{ $user->updated_at?->diffForHumans() ?? 'Recently' }}</div>
            </a>
        @empty
            <div class="table-row">
                <div>No users found.</div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>
@endsection
