@extends('ui.layouts.app')
@php($active = 'vendors')

@section('title', 'Vendor Details')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Vendor</p>
        <h1>Vendor {{ $vendorId ?? 'VND-01' }}</h1>
        <p class="sub">Supplier performance and quotes.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/vendors">Back to Vendors</a>
        <button class="btn btn-primary">Request Quote</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Vendor Profile</div>
        <div class="list">
            <div class="list-item"><span>Name</span><span class="chip">Summit Industrial</span></div>
            <div class="list-item"><span>Contact</span><span class="chip">Pat Rivera</span></div>
            <div class="list-item"><span>Lead Time</span><span class="chip">5 days</span></div>
            <div class="list-item"><span>Status</span><span class="badge badge-live">Preferred</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Quote History</div>
        <div class="list">
            <div class="list-item"><span>Quotes</span><span class="chip">12</span></div>
            <div class="list-item"><span>Avg Price</span><span class="chip">$220</span></div>
            <div class="list-item"><span>On-Time</span><span class="chip">96%</span></div>
        </div>
    </div>
</section>
@endsection


