@extends('ui.layouts.app')
@php($active = 'vendors')

@section('title', 'Vendors')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Suppliers</p>
        <h1>Vendor Management</h1>
        <p class="sub">Quotes, lead times, and preferred suppliers.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Request Quote</button>
        <button class="btn btn-primary">Add Vendor</button>
    </div>
</section>

<section class="card filters" data-filter-scope>
    <div class="filter-row">
        <input class="input" placeholder="Search vendors" data-filter-input />
        <select class="select" data-filter-status>
            <option value="all">Status: All</option>
            <option value="preferred">Preferred</option>
            <option value="approved">Approved</option>
            <option value="monitor">Monitor</option>
        </select>
        <select class="select" data-filter-site>
            <option value="all">Category: All</option>
            <option value="filters">Filters</option>
            <option value="lubricants">Lubricants</option>
            <option value="hydraulics">Hydraulics</option>
        </select>
        <button class="btn btn-ghost" type="button" data-export-button data-export-type="vendors">Export Selected</button>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Preferred Vendors</div>
            <div class="card-sub">Lead time performance</div>
        </div>
        <div class="chip">Q1 Reviews</div>
    </div>
    <div class="table">
        <div class="table-row table-head table-row-7">
            <div></div><div>Vendor</div><div>Category</div><div>Lead Time</div><div>On-Time</div><div>Status</div><div>Contact</div>
        </div>
        <div class="table-row table-row-7" data-row data-row-id="Summit Industrial" data-status="preferred" data-site="filters" data-search="summit industrial filters 5 days 96 preferred sales@summit">
            <div class="table-select"><input type="checkbox" data-row-select value="Summit Industrial" /></div>
            <div><a href="/ui/vendors/VND-01">Summit Industrial</a></div><div>Filters</div><div>5 days</div><div>96%</div><div><span class="badge badge-live">Preferred</span></div><div>sales@summit</div>
        </div>
        <div class="table-row table-row-7" data-row data-row-id="Terra Lube" data-status="approved" data-site="lubricants" data-search="terra lube lubricants 3 days 92 approved ops@terralube">
            <div class="table-select"><input type="checkbox" data-row-select value="Terra Lube" /></div>
            <div><a href="/ui/vendors/VND-02">Terra Lube</a></div><div>Lubricants</div><div>3 days</div><div>92%</div><div><span class="badge">Approved</span></div><div>ops@terralube</div>
        </div>
        <div class="table-row table-row-7" data-row data-row-id="Prime Spares" data-status="monitor" data-site="hydraulics" data-search="prime spares hydraulics 7 days 84 monitor hello@prime">
            <div class="table-select"><input type="checkbox" data-row-select value="Prime Spares" /></div>
            <div><a href="/ui/vendors/VND-03">Prime Spares</a></div><div>Hydraulics</div><div>7 days</div><div>84%</div><div><span class="badge badge-warning">Monitor</span></div><div>hello@prime</div>
        </div>
    </div>
</section>
@endsection


