@extends('ui.layouts.app')
@php($active = 'work-orders')
@php($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first())
@php($workOrder = $tenant ? \App\Models\WorkOrder::with(['asset', 'costs', 'parts.part'])->where('tenant_id', $tenant->id)->where(function ($query) use ($workOrderId) { $query->where('id', $workOrderId)->orWhere('reference_code', $workOrderId); })->first() : null)
@php($costs = $workOrder?->costs ?? collect())
@php($costTotals = $costs->groupBy('type')->map(fn ($items) => $items->sum('total_cost')))

@section('title', 'Work Order Details')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Work Order</p>
        <h1>{{ $workOrder?->reference_code ?? ('WO-' . ($workOrder?->id ?? $workOrderId ?? '')) }}</h1>
        <p class="sub">Corrective maintenance with parts and labor costs.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/work-orders">Back to Work Orders</a>
        <button class="btn btn-primary">Update Status</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Job Details</div>
        <div class="list">
            <div class="list-item"><span>Asset</span><span class="chip">{{ $workOrder?->asset?->name ?? 'Asset' }}</span></div>
            <div class="list-item"><span>Type</span><span class="chip">{{ ucfirst($workOrder?->type ?? 'service') }}</span></div>
            <div class="list-item"><span>Priority</span><span class="badge badge-warning">{{ ucfirst($workOrder?->priority ?? 'medium') }}</span></div>
            <div class="list-item"><span>Status</span><span class="badge badge-live">{{ ucfirst($workOrder?->status ?? 'open') }}</span></div>
        </div>
        <p class="sub">{{ $workOrder?->description ?? 'No description available.' }}</p>
    </div>
    <div class="card">
        <div class="card-title">Costs</div>
        <div class="list">
            <div class="list-item"><span>Labor</span><span class="chip">{{ isset($costTotals['labor']) ? '$' . number_format($costTotals['labor'], 0) : '-' }}</span></div>
            <div class="list-item"><span>Parts</span><span class="chip">{{ isset($costTotals['parts']) ? '$' . number_format($costTotals['parts'], 0) : '-' }}</span></div>
            <div class="list-item"><span>Contractor</span><span class="chip">{{ isset($costTotals['contractor']) ? '$' . number_format($costTotals['contractor'], 0) : '-' }}</span></div>
            <div class="list-item"><span>Total</span><span class="chip">{{ $workOrder?->total_cost ? '$' . number_format($workOrder->total_cost, 0) : '-' }}</span></div>
        </div>
    </div>
</section>

<section class="card">
    <div class="card-title">Parts Used</div>
    <div class="table">
        <div class="table-row table-head">
            <div>Part</div><div>Qty</div><div>Unit</div><div>Cost</div><div>Total</div><div>Status</div>
        </div>
        @forelse ($workOrder?->parts ?? [] as $part)
            <div class="table-row">
                <div>{{ $part->part?->name ?? 'Part' }}</div>
                <div>{{ $part->quantity ?? 1 }}</div>
                <div>{{ $part->part?->unit ?? 'pcs' }}</div>
                <div>{{ $part->unit_cost ? '$' . number_format($part->unit_cost, 0) : '-' }}</div>
                <div>{{ $part->total_cost ? '$' . number_format($part->total_cost, 0) : '-' }}</div>
                <div><span class="badge badge-live">Issued</span></div>
            </div>
        @empty
            <div class="table-row">
                <div>No parts logged.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>
@endsection



