@extends('ui.layouts.app')
@php($active = 'work-orders')
@php($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first())
@php($workOrders = $tenant ? \App\Models\WorkOrder::with('asset', 'assignedTo')->where('tenant_id', $tenant->id)->latest()->get() : collect())
@php($openCount = $workOrders->where('status', 'open')->count())
@php($inProgressCount = $workOrders->where('status', 'in_progress')->count())
@php($overdueCount = $workOrders->filter(fn ($wo) => $wo->due_at && $wo->due_at->isPast())->count())

@section('title', 'Work Orders')

@section('content')
<section class="page-head">
    <div>
        <p class="eyebrow">Maintenance</p>
        <h1>Work Orders</h1>
        <p class="sub">Preventive, corrective, and inspection jobs across the fleet.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Auto-Generate</button>
        <button class="btn btn-primary">New Work Order</button>
    </div>
</section>

<section class="grid-3">
    <div class="card">
        <div class="card-title">Open</div>
        <div class="metric">{{ $openCount }}</div>
        <div class="metric-sub">Awaiting assignment</div>
    </div>
    <div class="card">
        <div class="card-title">In Progress</div>
        <div class="metric">{{ $inProgressCount }}</div>
        <div class="metric-sub">On workshop floor</div>
    </div>
    <div class="card">
        <div class="card-title">Overdue</div>
        <div class="metric">{{ $overdueCount }}</div>
        <div class="metric-sub">Escalate to supervisor</div>
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Backlog Trend</div>
                <div class="card-sub">Open work orders</div>
            </div>
            <div class="chip">Last 10 weeks</div>
        </div>
        <div class="trend-chart">
            <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                <path class="trend-fill" d="M0 78 L40 70 L80 74 L120 66 L160 72 L200 60 L240 64 L260 58 L260 120 L0 120 Z"></path>
                <polyline class="trend-line" points="0,78 40,70 80,74 120,66 160,72 200,60 240,64 260,58"></polyline>
                <circle class="trend-dot" cx="120" cy="66" r="3"></circle>
                <circle class="trend-dot" cx="200" cy="60" r="3"></circle>
                <circle class="trend-dot" cx="260" cy="58" r="3"></circle>
            </svg>
        </div>
        <div class="trend-legend">
            <span>Open 22-34</span>
            <span>Overdue 6</span>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Work Order Mix</div>
                <div class="card-sub">By type</div>
            </div>
            <div class="chip">This month</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 72%"><span>Corrective</span></div>
                <div class="chart-bar" style="--value: 58%"><span>Preventive</span></div>
                <div class="chart-bar" style="--value: 36%"><span>Inspection</span></div>
            </div>
        </div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Active Jobs</div>
            <div class="card-sub">Prioritized by severity and downtime impact</div>
        </div>
        <div class="chip">Last updated 4m</div>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>WO</div><div>Asset</div><div>Type</div><div>Status</div><div>Priority</div><div>Owner</div>
        </div>
        @forelse ($workOrders->take(6) as $order)
            <a class="table-row" href="/ui/work-orders/{{ $order->id }}">
                <div>{{ $order->reference_code ?? ('WO-' . $order->id) }}</div>
                <div>{{ $order->asset?->name ?? 'Asset' }}</div>
                <div>{{ ucfirst($order->type ?? 'service') }}</div>
                <div><span class="badge {{ $order->status === 'open' ? 'badge-warning' : 'badge-live' }}">{{ ucfirst($order->status) }}</span></div>
                <div>{{ ucfirst($order->priority ?? 'medium') }}</div>
                <div>{{ $order->assignedTo?->name ?? 'Unassigned' }}</div>
            </a>
        @empty
            <div class="table-row">
                <div>No active jobs.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        @endforelse
    </div>
</section>
@endsection



