<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\TenantController;
use App\Http\Controllers\AssetController;
use App\Http\Controllers\VehicleController;
use App\Http\Controllers\TelemetryController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\WorkOrderController;
use App\Http\Controllers\PmScheduleController;
use App\Http\Controllers\ChecklistController;
use App\Http\Controllers\DowntimeReasonController;
use App\Http\Controllers\FuelLogController;
use App\Http\Controllers\TyreController;
use App\Http\Controllers\PartController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\InventoryLocationController;
use App\Http\Controllers\InventoryItemController;
use App\Http\Controllers\ImportController;
use App\Http\Controllers\DeviceController;
use App\Http\Controllers\AlarmController;
use App\Http\Controllers\AlarmRuleController;
use App\Http\Controllers\NotificationChannelController;
use App\Http\Controllers\NotificationRouteController;
use App\Http\Controllers\NotificationLogController;
use App\Http\Controllers\AuditLogController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\AiController;
use App\Http\Controllers\AiChatController;
use App\Http\Controllers\AiIntakeController;
use App\Http\Controllers\Telegram\TelegramWebhookController;
use App\Http\Controllers\Telegram\TelegramLinkController;
use App\Http\Controllers\Api\IotIngestController;
use App\Http\Controllers\Api\CamIngestController;

Route::post('telegram/webhook', [TelegramWebhookController::class, 'handle']);
Route::post('telegram/link', [TelegramLinkController::class, 'link']);

Route::prefix('iot')->middleware('device.key')->group(function () {
    Route::post('sensors/reading', [IotIngestController::class, 'ingestSensor']);
    Route::post('scale/weight', [IotIngestController::class, 'ingestWeight']);
    Route::post('cam/frame', [CamIngestController::class, 'storeFrame']);
    Route::post('cam/event', [CamIngestController::class, 'storeEvent']);
});

Route::prefix('auth')->group(function () {
    Route::post('register', [AuthController::class, 'register']);
    Route::post('login', [AuthController::class, 'login']);
});

Route::post('ai/chat', [AiChatController::class, 'chat'])->middleware('throttle:20,1');
Route::get('ai/intake/{batch}', [AiIntakeController::class, 'show'])->middleware('throttle:20,1');
Route::post('ai/intake/{batch}/apply', [AiIntakeController::class, 'apply'])->middleware('throttle:20,1');

Route::middleware('auth:sanctum')->group(function () {
    Route::post('auth/logout', [AuthController::class, 'logout']);

    // Tenant Routes
    Route::prefix('tenants')->group(function () {
        Route::post('/', [TenantController::class, 'store']);
        Route::get('/', [TenantController::class, 'index']);
        Route::get('{tenant}', [TenantController::class, 'show']);
        Route::put('{tenant}', [TenantController::class, 'update']);
        Route::delete('{tenant}', [TenantController::class, 'destroy']);
    });

    Route::middleware('tenant')->group(function () {
        // Sites
        Route::prefix('sites')->group(function () {
            Route::get('/', [SiteController::class, 'index']);
            Route::post('/', [SiteController::class, 'store']);
        });

        // Asset Routes
        Route::prefix('assets')->group(function () {
            Route::post('/', [AssetController::class, 'store']);
            Route::get('/', [AssetController::class, 'index']);
            Route::get('{asset}', [AssetController::class, 'show']);
            Route::put('{asset}', [AssetController::class, 'update']);
            Route::delete('{asset}', [AssetController::class, 'destroy']);
        });

        // Vehicle Routes
        Route::prefix('vehicles')->group(function () {
            Route::post('/', [VehicleController::class, 'store']);
            Route::get('/', [VehicleController::class, 'index']);
            Route::get('{vehicle}', [VehicleController::class, 'show']);
            Route::put('{vehicle}', [VehicleController::class, 'update']);
            Route::delete('{vehicle}', [VehicleController::class, 'destroy']);
        });

        // Telemetry Routes
        Route::prefix('telemetry')->group(function () {
            Route::post('/', [TelemetryController::class, 'ingest']);
            Route::get('/', [TelemetryController::class, 'index']);
        });

        // Work Orders & PM
        Route::prefix('work-orders')->group(function () {
            Route::get('/', [WorkOrderController::class, 'index']);
            Route::post('/', [WorkOrderController::class, 'store']);
            Route::get('{workOrder}', [WorkOrderController::class, 'show']);
            Route::put('{workOrder}', [WorkOrderController::class, 'update']);
        });

        Route::prefix('pm-schedules')->group(function () {
            Route::get('/', [PmScheduleController::class, 'index']);
            Route::post('/', [PmScheduleController::class, 'store']);
        });

        Route::prefix('checklists')->group(function () {
            Route::get('/', [ChecklistController::class, 'index']);
            Route::post('/', [ChecklistController::class, 'store']);
        });

        Route::prefix('downtime-reasons')->group(function () {
            Route::get('/', [DowntimeReasonController::class, 'index']);
            Route::post('/', [DowntimeReasonController::class, 'store']);
        });

        // Fuel, Tyres, Inventory
        Route::prefix('fuel-logs')->group(function () {
            Route::get('/', [FuelLogController::class, 'index']);
            Route::post('/', [FuelLogController::class, 'store']);
        });

        Route::prefix('tyres')->group(function () {
            Route::get('/', [TyreController::class, 'index']);
            Route::post('/', [TyreController::class, 'store']);
        });

        Route::prefix('parts')->group(function () {
            Route::get('/', [PartController::class, 'index']);
            Route::post('/', [PartController::class, 'store']);
        });

        Route::prefix('vendors')->group(function () {
            Route::get('/', [VendorController::class, 'index']);
            Route::post('/', [VendorController::class, 'store']);
        });

        Route::prefix('inventory-locations')->group(function () {
            Route::get('/', [InventoryLocationController::class, 'index']);
            Route::post('/', [InventoryLocationController::class, 'store']);
        });

        Route::prefix('inventory-items')->group(function () {
            Route::get('/', [InventoryItemController::class, 'index']);
            Route::post('/', [InventoryItemController::class, 'store']);
        });

        // Imports
        Route::prefix('imports')->group(function () {
            Route::get('/', [ImportController::class, 'index']);
            Route::post('/', [ImportController::class, 'store']);
            Route::get('{importBatch}', [ImportController::class, 'show']);
        });

        // Devices & Sensors
        Route::prefix('devices')->group(function () {
            Route::get('/', [DeviceController::class, 'index']);
            Route::post('/', [DeviceController::class, 'store']);
            Route::post('{device}/ingest', [DeviceController::class, 'ingest'])->middleware('throttle:60,1');
            Route::post('ingest', [DeviceController::class, 'ingestByIdentifier'])->middleware('throttle:60,1');
        });

        // Alarms
        Route::prefix('alarms')->group(function () {
            Route::get('/', [AlarmController::class, 'index']);
            Route::post('{alarm}/acknowledge', [AlarmController::class, 'acknowledge']);
        });

        Route::prefix('alarm-rules')->group(function () {
            Route::get('/', [AlarmRuleController::class, 'index']);
            Route::post('/', [AlarmRuleController::class, 'store']);
        });

        // Notifications
        Route::prefix('notifications')->group(function () {
            Route::get('channels', [NotificationChannelController::class, 'index']);
            Route::post('channels', [NotificationChannelController::class, 'store']);
            Route::get('routes', [NotificationRouteController::class, 'index']);
            Route::post('routes', [NotificationRouteController::class, 'store']);
            Route::get('logs', [NotificationLogController::class, 'index']);
        });

        // Roles
        Route::prefix('roles')->group(function () {
            Route::get('/', [RoleController::class, 'index']);
            Route::post('/', [RoleController::class, 'store']);
            Route::post('assign/{user}', [RoleController::class, 'assign']);
        });

        // AI
        Route::prefix('ai')->group(function () {
            Route::get('insights', [AiController::class, 'insights']);
            Route::get('reports', [AiController::class, 'reports']);
        });

        // Audit
        Route::get('audit-logs', [AuditLogController::class, 'index']);
    });
});
