<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TenantController;
use App\Http\Controllers\AssetController;
use App\Http\Controllers\VehicleController;
use App\Http\Controllers\TelemetryController;
use App\Http\Controllers\DownloadTemplateController;
use App\Http\Controllers\SupplyChainExportController;
use App\Http\Controllers\PurchaseRequestItemController;
use App\Http\Controllers\ReconciliationController;
use App\Http\Controllers\Web\DashboardController;
use App\Http\Controllers\Web\HouseController;
use App\Http\Controllers\Web\AlertController as PoultryAlertController;
use App\Http\Controllers\Web\ReportController as PoultryReportController;
use App\Models\AgentNotification;

Route::get('/', function () {
    return response()->json(['status' => 'ok']);
});

Route::view('/home', 'ui.dashboard')->name('home');

Route::prefix('ui')->group(function () {
    Route::view('/', 'ui.dashboard');
    Route::view('/assets', 'ui.assets');
    Route::get('/assets/{asset}', function ($asset) {
        return view('ui.asset-detail', ['assetId' => $asset]);
    });
    Route::view('/vehicles', 'ui.vehicles');
    Route::get('/vehicles/{vehicle}', function ($vehicle) {
        return view('ui.vehicle-detail', ['vehicleId' => $vehicle]);
    });
    Route::view('/trips', 'ui.trips');
    Route::get('/trips/{trip}', function ($trip) {
        return view('ui.trip-detail', ['tripId' => $trip]);
    });
    Route::view('/maintenance', 'ui.maintenance');
    Route::view('/work-orders', 'ui.work-orders');
    Route::get('/work-orders/{workOrder}', function ($workOrder) {
        return view('ui.work-order-detail', ['workOrderId' => $workOrder]);
    });
    Route::view('/pm-schedules', 'ui.pm-schedules');
    Route::get('/pm-schedules/{schedule}', function ($schedule) {
        return view('ui.pm-schedule-detail', ['scheduleId' => $schedule]);
    });
    Route::view('/checklists', 'ui.checklists');
    Route::get('/checklists/{checklist}', function ($checklist) {
        return view('ui.checklist-detail', ['checklistId' => $checklist]);
    });
    Route::view('/downtime', 'ui.downtime');
    Route::get('/downtime/{downtime}', function ($downtime) {
        return view('ui.downtime-detail', ['downtimeId' => $downtime]);
    });
    Route::view('/fuel', 'ui.fuel');
    Route::get('/fuel/{fuel}', function ($fuel) {
        return view('ui.fuel-detail', ['fuelId' => $fuel]);
    });
    Route::view('/tyres', 'ui.tyres');
    Route::get('/tyres/{tyre}', function ($tyre) {
        return view('ui.tyre-detail', ['tyreId' => $tyre]);
    });
    Route::view('/telemetry', 'ui.telemetry');
    Route::get('/telemetry/{telemetry}', function ($telemetry) {
        return view('ui.telemetry-detail', ['telemetryId' => $telemetry]);
    });
    Route::view('/sites', 'ui.sites');
    Route::get('/sites/{site}', function ($site) {
        return view('ui.site-detail', ['siteId' => $site]);
    });
    Route::view('/inventory', 'ui.inventory');
    Route::get('/inventory/{item}', function ($item) {
        return view('ui.inventory-detail', ['itemId' => $item]);
    });
    Route::view('/vendors', 'ui.vendors');
    Route::get('/vendors/{vendor}', function ($vendor) {
        return view('ui.vendor-detail', ['vendorId' => $vendor]);
    });
    Route::view('/purchase-requests', 'ui.purchase-requests');
    Route::get('/purchase-requests/{request}', function ($request) {
        return view('ui.purchase-request-detail', ['requestId' => $request]);
    });
    Route::view('/purchase-orders', 'ui.purchase-orders');
    Route::get('/purchase-orders/{order}', function ($order) {
        return view('ui.purchase-order-detail', ['orderId' => $order]);
    });
    Route::view('/payments', 'ui.payments');
    Route::get('/payments/{payment}', function ($payment) {
        return view('ui.payment-detail', ['paymentId' => $payment]);
    });
    Route::view('/imports', 'ui.imports');
    Route::get('/imports/{batch}', function ($batch) {
        return view('ui.import-detail', ['batchId' => $batch]);
    });
    Route::view('/devices', 'ui.devices');
    Route::get('/devices/{device}', function ($device) {
        return view('ui.device-detail', ['deviceId' => $device]);
    });
    Route::view('/alerts', 'ui.alerts');
    Route::get('/alerts/{alert}', function ($alert) {
        return view('ui.alert-detail', ['alertId' => $alert]);
    });
    Route::view('/alarm-rules', 'ui.alarm-rules');
    Route::get('/alarm-rules/{rule}', function ($rule) {
        return view('ui.alarm-rule-detail', ['ruleId' => $rule]);
    });
    Route::view('/kpis', 'ui.kpis');
    Route::get('/kpis/{kpi}', function ($kpi) {
        return view('ui.kpi-detail', ['kpiId' => $kpi]);
    });
    Route::view('/ai', 'ui.ai');
    Route::get('/ai/{insight}', function ($insight) {
        return view('ui.ai-detail', ['insightId' => $insight]);
    });
    Route::get('/agent-notifications', function () {
        $notifications = AgentNotification::orderByDesc('created_at')->limit(50)->get();
        return view('ui.agent-notifications', ['notifications' => $notifications]);
    });
    Route::get('/agent-notifications/{notification}', function (AgentNotification $notification) {
        return view('ui.agent-notification-detail', ['notification' => $notification]);
    });
    Route::view('/reports', 'ui.reports');
    Route::get('/reports/{report}', function ($report) {
        return view('ui.report-detail', ['reportId' => $report]);
    });
    Route::view('/tenants', 'ui.tenants');
    Route::get('/tenants/{tenant}', function ($tenant) {
        return view('ui.tenant-detail', ['tenantId' => $tenant]);
    });
    Route::view('/users', 'ui.users');
    Route::get('/users/{user}', function ($user) {
        return view('ui.user-detail', ['userId' => $user]);
    });
    Route::view('/roles', 'ui.roles');
    Route::get('/roles/{role}', function ($role) {
        return view('ui.role-detail', ['roleId' => $role]);
    });
    Route::view('/notifications', 'ui.notifications');
    Route::get('/notifications/{notification}', function ($notification) {
        return view('ui.notification-detail', ['notificationId' => $notification]);
    });
    Route::view('/audit', 'ui.audit');
    Route::get('/audit/{audit}', function ($audit) {
        return view('ui.audit-detail', ['auditId' => $audit]);
    });
    Route::get('/reconciliation', [ReconciliationController::class, 'index']);
    Route::post('/reconciliation/run', [ReconciliationController::class, 'run']);
    Route::post('/reconciliation/{link}/apply', [ReconciliationController::class, 'apply']);
    Route::post('/reconciliation/{link}/ignore', [ReconciliationController::class, 'ignore']);
    Route::view('/settings', 'ui.settings');
});

Route::get('/exports/supply-chain', [SupplyChainExportController::class, 'export']);
Route::get('/exports/purchase-requests/{purchaseRequest}/{format}', [SupplyChainExportController::class, 'exportRequest']);
Route::get('/exports/dashboard-snapshot.pdf', [DownloadTemplateController::class, 'dashboardSnapshot']);
Route::get('/exports/audit-log.pdf', [DownloadTemplateController::class, 'auditLog']);
Route::get('/exports/audit/{audit}/pdf', [DownloadTemplateController::class, 'auditEntry']);
Route::get('/exports/kpis.pdf', [DownloadTemplateController::class, 'kpis']);
Route::get('/exports/maintenance.pdf', [DownloadTemplateController::class, 'maintenance']);
Route::get('/exports/sites.pdf', [DownloadTemplateController::class, 'sites']);
Route::get('/exports/telemetry/{telemetry}/pdf', [DownloadTemplateController::class, 'telemetry']);
Route::get('/exports/payments/{payment}/pdf', [DownloadTemplateController::class, 'payment']);
Route::get('/exports/purchase-orders/{order}/pdf', [DownloadTemplateController::class, 'purchaseOrder']);
Route::get('/exports/reports/pack/pdf', [DownloadTemplateController::class, 'reportPack']);
Route::get('/exports/reports/{report}/pdf', [DownloadTemplateController::class, 'report']);
Route::get('/exports/reports/{report}/ppt', [DownloadTemplateController::class, 'reportPpt']);
Route::get('/exports/import-template.csv', [DownloadTemplateController::class, 'importTemplate']);

Route::patch('/purchase-request-items/{item}', [PurchaseRequestItemController::class, 'update']);
Route::post('/purchase-request-items/{item}/documents', [PurchaseRequestItemController::class, 'uploadDocument']);
Route::get('/purchase-request-items/{item}/documents/{document}', [PurchaseRequestItemController::class, 'downloadDocument'])->name('purchase-request-item-documents.download');

Route::middleware(['auth', 'tenant'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('poultry.dashboard');
    Route::get('/houses/{house}', [HouseController::class, 'show'])->name('poultry.houses.show');
    Route::post('/houses/{house}/ai', [HouseController::class, 'generateReport'])->name('poultry.houses.ai');
    Route::get('/alerts', [PoultryAlertController::class, 'index'])->name('poultry.alerts.index');
    Route::get('/reports', [PoultryReportController::class, 'index'])->name('poultry.reports.index');
    Route::get('/reports/{report}', [PoultryReportController::class, 'show'])->name('poultry.reports.show');

    // Web routes for tenant management
    Route::prefix('tenants')->group(function () {
        Route::get('/', [TenantController::class, 'index'])->name('tenants.index');
        Route::post('/', [TenantController::class, 'store'])->name('tenants.store');
        Route::get('/{tenant}', [TenantController::class, 'show'])->name('tenants.show');
        Route::put('/{tenant}', [TenantController::class, 'update'])->name('tenants.update');
        Route::delete('/{tenant}', [TenantController::class, 'destroy'])->name('tenants.destroy');
    });

    // Web routes for asset management
    Route::prefix('assets')->group(function () {
        Route::get('/', [AssetController::class, 'index'])->name('assets.index');
        Route::post('/', [AssetController::class, 'store'])->name('assets.store');
        Route::get('/{asset}', [AssetController::class, 'show'])->name('assets.show');
        Route::put('/{asset}', [AssetController::class, 'update'])->name('assets.update');
        Route::delete('/{asset}', [AssetController::class, 'destroy'])->name('assets.destroy');
    });

    // Web routes for vehicle management
    Route::prefix('vehicles')->group(function () {
        Route::get('/', [VehicleController::class, 'index'])->name('vehicles.index');
        Route::post('/', [VehicleController::class, 'store'])->name('vehicles.store');
        Route::get('/{vehicle}', [VehicleController::class, 'show'])->name('vehicles.show');
        Route::put('/{vehicle}', [VehicleController::class, 'update'])->name('vehicles.update');
        Route::delete('/{vehicle}', [VehicleController::class, 'destroy'])->name('vehicles.destroy');
    });

    // Web routes for telemetry data management
    Route::prefix('telemetry')->group(function () {
        Route::get('/', [TelemetryController::class, 'index'])->name('telemetry.index');
        Route::post('/', [TelemetryController::class, 'ingest'])->name('telemetry.store');
    });
});
