const fs = require('fs');
const path = require('path');
const { chromium } = require('playwright');

const root = path.resolve(__dirname, '..');
const previewDir = path.join(root, 'public', 'ui-previews');
const outputDir = path.join(previewDir, 'screens');

const pageOrder = [
    'dashboard',
    'assets',
    'vehicles',
    'trips',
    'maintenance',
    'telemetry',
    'alerts',
    'kpis',
    'ai',
    'reports',
    'tenants',
    'users',
    'settings',
];

async function capture() {
    fs.mkdirSync(outputDir, { recursive: true });

    const browser = await chromium.launch();
    const page = await browser.newPage({ viewport: { width: 1440, height: 900 } });

    for (const name of pageOrder) {
        const filePath = path.join(previewDir, `${name}.html`);
        if (!fs.existsSync(filePath)) {
            console.warn(`Missing preview for ${name}`);
            continue;
        }
        const uri = `file:///${filePath.replace(/\\\\/g, '/')}`;
        await page.goto(uri, { waitUntil: 'networkidle' });
        await page.waitForTimeout(800);
        const outPath = path.join(outputDir, `${name}.png`);
        await page.screenshot({ path: outPath, fullPage: true });
        console.log(`Saved ${outPath}`);
    }

    await browser.close();
}

capture().catch((err) => {
    console.error(err);
    process.exit(1);
});
