from pathlib import Path
import re

in_path = Path('database/full_dump_mysql.sql')
out_path = Path('database/full_dump_mysql_fixed.sql')

text = in_path.read_text(encoding='utf-8')
lines = text.splitlines()

out_lines = []
foreign_keys = []
create_buffer = []
in_create = False
current_table = None

create_re = re.compile(r'^CREATE TABLE `([^`]+)`')


def flush_create():
    if not create_buffer:
        return
    idx = len(create_buffer) - 1
    while idx >= 0 and create_buffer[idx].strip() == '':
        idx -= 1
    if idx >= 0 and create_buffer[idx].rstrip().endswith(','):
        create_buffer[idx] = create_buffer[idx].rstrip().rstrip(',')
    out_lines.extend(create_buffer)
    create_buffer.clear()


for line in lines:
    if not in_create:
        match = create_re.match(line)
        if match:
            in_create = True
            current_table = match.group(1)
            create_buffer.append(line)
            continue
        out_lines.append(line)
        continue

    if line.strip().startswith('FOREIGN KEY'):
        fk_line = line.strip().rstrip(',')
        foreign_keys.append(f"ALTER TABLE `{current_table}` ADD {fk_line};")
        continue

    if line.strip().startswith(') ENGINE'):
        flush_create()
        out_lines.append(line)
        out_lines.append('')
        in_create = False
        current_table = None
        continue

    create_buffer.append(line)

flush_create()

if foreign_keys:
    out_lines.append('-- Foreign key constraints')
    out_lines.extend(foreign_keys)
    out_lines.append('')

out_path.write_text('\n'.join(out_lines) + '\n', encoding='utf-8')
print(f"Wrote {out_path}")
print(f"Foreign keys extracted: {len(foreign_keys)}")
