<?php
use App\Domain\Telegram\TelegramNotifier;
use App\Models\AgentNotification;

require __DIR__ . '/../vendor/autoload.php';
$app = require __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$tenantId = 31;
$userId = 1;
$notifier = app(TelegramNotifier::class);

$agents = [
    [
        'key' => 'maintenance_compliance',
        'name' => 'Maintenance Compliance Agent',
        'severity' => 'warn',
        'title' => 'Maintenance Compliance',
        'recipients' => ['maintenance', 'management'],
        'summary' => "AI Agent: Maintenance Compliance\nOverdue assets:\n- ME-EXC-03 - Excavator 03 | 4d overdue | Risk: Medium\n- CP-CONV-02 - Conveyor 02 | 220h overdue | Risk: Medium\n- DT-TIP-05 - Tipper 05 | 15d overdue | Risk: High",
    ],
    [
        'key' => 'failure_prediction',
        'name' => 'Failure Prediction Agent',
        'severity' => 'alarm',
        'title' => 'Failure Prediction',
        'recipients' => ['maintenance', 'management'],
        'summary' => "AI Agent: Failure Prediction\nSignals:\n- CP-JAW-02 - Jaw Crusher 02 | downtime 12.4h (30d)\n- ME-LDR-02 - Loader 02 | spares spend $7,980\n- BP-GEN-01 - Generator 01 | fuel variance 24\nRecommendations:\n- Inspect crusher bearings within 48h.\n- Review loader hydraulic leaks.\n- Check generator fuel sensor calibration.",
    ],
    [
        'key' => 'kpi_analyst',
        'name' => 'KPI Analyst Agent',
        'severity' => 'warn',
        'title' => 'Weekly KPI Report',
        'recipients' => ['management'],
        'summary' => "AI Agent: KPI Analyst\n- Availability: 82.6%\n- Utilization: 58.3%\n- MTBF: 31h\n- Fuel efficiency: 19.1 L/hr\nRisks: Downtime 6.8h this week.\nWins: PM completion improved by 9%.",
    ],
    [
        'key' => 'cost_control',
        'name' => 'Cost Control Agent',
        'severity' => 'alarm',
        'title' => 'Cost Control Alert',
        'recipients' => ['maintenance', 'management'],
        'summary' => "AI Agent: Cost Control\n- Maintenance costs spiked to $18,250 (avg $9,600)\n- Fuel costs spiked to $7,890 (avg $4,700)\nRecommendation: Validate invoices and review high-cost work orders.",
    ],
    [
        'key' => 'ops_notifier',
        'name' => 'Ops Notifier Agent',
        'severity' => 'alarm',
        'title' => 'Ops Notifier',
        'recipients' => ['management'],
        'summary' => "AI Agent: Ops Notifier\nCritical findings:\n- DT-TIP-05 - Tipper 05 | Service overdue 15d\n- CP-JAW-02 - Jaw Crusher 02 | Failure risk high\n- BP-GEN-01 - Generator 01 | Fuel variance alert",
    ],
    [
        'key' => 'finance_oversight',
        'name' => 'Finance Oversight Agent',
        'severity' => 'alarm',
        'title' => 'Finance Oversight Digest',
        'recipients' => ['management', 'procurement'],
        'summary' => "AI Agent: Finance Oversight\n- PR aging: 6.4 days | PO aging: 9.8 days | Invoice aging: 18.1 days\n- Unpaid total: $42,850 | Spend vs budget: 128%\nFindings:\n- Duplicate invoice detected (INV-2213)\n- Invoice missing PO/GRN link (INV-2291)\n- PO overdue delivery (PO-0187)\nSuggested action: HOLD_PAYMENT",
    ],
    [
        'key' => 'hr_artisan_performance',
        'name' => 'HR Artisan Performance Agent',
        'severity' => 'warn',
        'title' => 'Artisan Performance Summary',
        'recipients' => ['management', 'maintenance'],
        'summary' => "AI Agent: HR Artisan Performance\n- Tendai Moyo: assigned 12, completed 9, utilization 46%, compliance 62%\n- Farai Dube: assigned 8, completed 8, utilization 74%, compliance 91%\n- Memory Ncube: assigned 6, completed 3, utilization 29%, compliance 45%\nFindings:\n- Low utilization (<30%) (Memory Ncube)\n- Checklist compliance below 50% (Memory Ncube)\nSuggested action: REVIEW_SUPERVISOR",
    ],
];

foreach ($agents as $agent) {
    AgentNotification::create([
        'tenant_id' => $tenantId,
        'agent_key' => $agent['key'],
        'agent_name' => $agent['name'],
        'severity' => $agent['severity'],
        'title' => $agent['title'],
        'summary' => $agent['summary'],
        'payload' => [
            'prompt' => config('ai_agents.prompts.' . $agent['key']),
            'sample' => true,
        ],
        'recipients' => $agent['recipients'],
        'status' => 'sent',
        'sent_at' => now(),
    ]);

    $notifier->notifyUser($userId, $agent['summary']);
}

echo "Sent " . count($agents) . " sample agent notifications.\n";
