# Laravel AI Asset & Fleet Management SaaS

## Overview
This project is a Laravel-based Software as a Service (SaaS) solution designed for asset and fleet management with a multi-tenant architecture. It is specifically tailored for the mining, quarrying, and construction industries. The application provides tools for managing assets, vehicles, telemetry data, trips, maintenance records, and alerts, along with AI-driven automation features and a robust API for integration with other systems.

## Features
- Multi-tenant architecture for managing multiple clients
- User authentication and role-based access control (RBAC)
- Tenant management for creating, updating, and deleting tenants
- Sites/locations, asset assignments, and audit logging
- Asset lifecycle tracking including registration, updates, and maintenance
- Work orders, PM schedules, checklists, downtime, and cost tracking
- Vehicle management with telemetry data ingestion and processing
- Fuel logs, tyre management, parts & inventory, and vendor management
- Maintenance scheduling and work order management
- Trip management for efficient logistics
- AI-driven automation for asset management and operational efficiency
- AI-assisted imports for asset registers, service sheets, and invoices
- AI maintenance insights (root cause suggestions, PM interval recommendations)
- Sensor ingestion pipeline with rules-based alarms and notifications
- Alert system for maintenance and operational issues
- KPI tracking and reporting for performance analysis
- Dashboard for real-time insights and analytics

## Installation
1. Clone the repository:
   ```
   git clone https://github.com/yourusername/laravel-ai-asset-fleet-saas.git
   ```
2. Navigate to the project directory:
   ```
   cd laravel-ai-asset-fleet-saas
   ```
3. Ensure PHP 8.2+ is available. If you do not have PHP 8.2 installed, you can use the bundled binary:
   ```
   # Windows (PowerShell)
   .\tools\php-8.2.30\php.exe tools\composer.phar install
   ```
   When using the bundled PHP, prefix artisan commands with `.\tools\php-8.2.30\php.exe`.
4. Install dependencies:
   ```
   composer install
   npm install
   ```
5. Copy the `.env.example` to `.env` and configure your environment variables:
   ```
   cp .env.example .env
   ```
   The default `.env.example` is configured for SQLite. Ensure the database file exists:
   ```
   # Windows (PowerShell)
   type nul > database/database.sqlite
   # macOS/Linux
   touch database/database.sqlite
   ```
6. Generate the application key:
   ```
   php artisan key:generate
   ```
7. Run the migrations:
   ```
   php artisan migrate
   ```
8. Seed the database (optional):
   ```
   php artisan db:seed
   ```
9. Start the development server:
   ```
   php artisan serve
   ```

## Background Jobs
Imports, sensor normalization, and weekly KPI reports are queued. In development you can keep `QUEUE_CONNECTION=sync` or switch to database queues:
```
php artisan migrate
php artisan queue:work
```

## Folder Structure
- `app/`: Contains the core application logic including models, controllers, and services.
- `bootstrap/`: Contains the files for bootstrapping the application.
- `config/`: Configuration files for various services and settings.
- `database/`: Contains migrations, seeders, and factories for database management.
- `docs/`: Documentation files including API routes, RBAC roles, multi-tenancy architecture, and AI automation.
- `public/`: Publicly accessible files including the entry point for the application.
- `resources/`: Contains views, JavaScript, and CSS files.
- `routes/`: Defines the API and web routes for the application.
- `storage/`: Storage for logs, cache, and other files.
- `tests/`: Contains feature and unit tests for the application.

## API Documentation
Refer to the `docs/API_ROUTES.md` for detailed API endpoints and usage.

## RBAC Roles
Refer to the `docs/RBAC_ROLES.md` for a detailed description of user roles and permissions.

## Multi-Tenancy
Refer to the `docs/MULTI_TENANCY.md` for information on the multi-tenancy architecture and implementation.

## AI Automation
Refer to the `docs/AI_AUTOMATION.md` for details on AI-driven features and automation processes.

## KPI Formulas
Refer to the `docs/KPI_FORMULAS.md` for key performance indicators and their calculations.

## Contributing
Contributions are welcome! Please submit a pull request or open an issue for any enhancements or bug fixes.

## License
This project is licensed under the MIT License. See the LICENSE file for details.
