
<?php ($active = 'vehicles'); ?>
<?php ($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first()); ?>
<?php ($vehicle = $tenant ? \App\Models\Vehicle::with('site', 'asset')->where('tenant_id', $tenant->id)->where('id', $vehicleId)->first() : null); ?>
<?php ($asset = $vehicle?->asset); ?>
<?php ($workOrders = $asset ? $asset->workOrders()->latest()->take(3)->get() : collect()); ?>
<?php ($aiInsights = $asset ? \App\Models\AiInsight::where('tenant_id', $tenant->id)->where('asset_id', $asset->id)->latest()->take(3)->get() : collect()); ?>
<?php ($telemetry = $vehicle ? \App\Models\Telemetry::where('vehicle_id', $vehicle->id)->latest()->first() : null); ?>

<?php $__env->startSection('title', 'Vehicle Details'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Fleet Detail</p>
        <h1><?php echo e($vehicle?->name ?? 'Vehicle'); ?> - <?php echo e($vehicle?->asset?->asset_tag ?? $vehicleId ?? 'V'); ?></h1>
        <p class="sub">Live status, telemetry, and assignments.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/vehicles">Back to Fleet</a>
        <button class="btn btn-primary">Edit Vehicle</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Vehicle Profile</div>
        <div class="list">
            <div class="list-item"><span>Type</span><span class="chip"><?php echo e($vehicle?->type ?? 'Vehicle'); ?></span></div>
            <div class="list-item"><span>Plate</span><span class="chip"><?php echo e($vehicle?->license_plate ?? '-'); ?></span></div>
            <div class="list-item"><span>Site</span><span class="chip"><?php echo e($vehicle?->site?->name ?? 'Unassigned'); ?></span></div>
            <div class="list-item"><span>Status</span><span class="badge badge-live"><?php echo e(ucfirst($vehicle?->status ?? 'active')); ?></span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Utilization</div>
        <div class="metric"><?php echo e($vehicle ? 70 + ($vehicle->id % 25) : '-'); ?>%</div>
        <div class="metric-sub">Shift readiness</div>
        <div class="list">
            <div class="list-item"><span>Odometer</span><span class="chip"><?php echo e($vehicle?->odometer ? number_format($vehicle->odometer, 0) . ' km' : '-'); ?></span></div>
            <div class="list-item"><span>Engine Hours</span><span class="chip"><?php echo e($vehicle?->engine_hours ? number_format($vehicle->engine_hours, 0) . ' hrs' : '-'); ?></span></div>
            <?php ($nextService = $vehicle && is_array($vehicle->maintenance_schedule) ? ($vehicle->maintenance_schedule['next_service_hours'] ?? null) : null); ?>
            <div class="list-item"><span>Next Service</span><span class="chip"><?php echo e($nextService !== null ? $nextService . ' hrs' : '-'); ?></span></div>
        </div>
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Availability Trend</div>
                <div class="card-sub">Last 12 weeks</div>
            </div>
            <span class="chip">93.8% avg</span>
        </div>
        <div class="trend-chart">
            <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                <path class="trend-fill" d="M0 96 L40 86 L80 72 L120 80 L160 58 L200 66 L240 44 L260 52 L260 120 L0 120 Z"></path>
                <polyline class="trend-line" points="0,96 40,86 80,72 120,80 160,58 200,66 240,44 260,52"></polyline>
                <circle class="trend-dot" cx="80" cy="72" r="3"></circle>
                <circle class="trend-dot" cx="160" cy="58" r="3"></circle>
                <circle class="trend-dot" cx="240" cy="44" r="3"></circle>
                <circle class="trend-dot" cx="260" cy="52" r="3"></circle>
            </svg>
        </div>
        <div class="trend-legend">
            <span>Availability 82-96%</span>
            <span>Idle time 9.8h</span>
        </div>
    </article>
    <article class="card">
        <div class="card-title">Reliability & Incidents</div>
        <div class="stat-grid">
            <div class="stat-card">
                <div class="stat-label">MTBF</div>
                <div class="stat-value">198 hrs</div>
                <div class="stat-sub">+5% vs last quarter</div>
            </div>
            <div class="stat-card">
                <div class="stat-label">MTTR</div>
                <div class="stat-value">4.1 hrs</div>
                <div class="stat-sub">-8% vs last quarter</div>
            </div>
            <div class="stat-card">
                <div class="stat-label">Reliability</div>
                <div class="stat-value">94.2%</div>
                <div class="stat-sub">Target 93%</div>
            </div>
        </div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Brake fade</div>
                    <div class="item-sub">2 incidents in 30 days</div>
                </div>
                <span class="badge badge-warning">Watch</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Fuel spike</div>
                    <div class="item-sub">1 incident in 30 days</div>
                </div>
                <span class="badge">Monitor</span>
            </div>
        </div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Maintenance History</div>
            <div class="card-sub">Last 90 days</div>
        </div>
        <button class="btn btn-ghost">View all</button>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Date</div><div>Work Order</div><div>Type</div><div>Downtime</div><div>Cost</div><div>Status</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $workOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="table-row">
                <div><?php echo e(($order->completed_at ?? $order->created_at)?->format('M d') ?? '-'); ?></div>
                <div><?php echo e($order->reference_code ?? ('WO-' . $order->id)); ?></div>
                <div><?php echo e(ucfirst($order->type ?? 'service')); ?></div>
                <div>-</div>
                <div><?php echo e($order->total_cost ? '$' . number_format($order->total_cost, 0) : '-'); ?></div>
                <div><span class="badge <?php echo e($order->status === 'open' ? 'badge-warning' : 'badge-live'); ?>"><?php echo e(ucfirst($order->status)); ?></span></div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row">
                <div>No maintenance history yet.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-title">Maintenance Costs</div>
        <?php ($totalCost = $asset ? $asset->workOrders()->sum('total_cost') : 0); ?>
        <?php ($recentCost = $asset ? $asset->workOrders()->where('created_at', '>=', now()->subDays(30))->sum('total_cost') : 0); ?>
        <div class="metric"><?php echo e($totalCost ? '$' . number_format($totalCost, 0) : '-'); ?></div>
        <div class="metric-sub">YTD | Last 30 days: <?php echo e($recentCost ? '$' . number_format($recentCost, 0) : '-'); ?></div>
        <div class="cost-row"><span>Labor</span><span class="chip">-</span></div>
        <div class="cost-row"><span>Parts</span><span class="chip">-</span></div>
        <div class="cost-row"><span>Contractor</span><span class="chip">-</span></div>
        <div class="cost-row"><span>Fuel / Fluids</span><span class="chip">-</span></div>
    </article>
    <article class="card">
        <div class="card-title">AI Predictions</div>
        <div class="list">
            <?php $__empty_1 = true; $__currentLoopData = $aiInsights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="list-item">
                    <div>
                        <div class="item-title"><?php echo e(ucfirst(str_replace('_', ' ', $insight->type))); ?></div>
                        <div class="item-sub"><?php echo e($insight->payload['summary'] ?? 'AI insight available'); ?></div>
                    </div>
                    <span class="badge badge-ai"><?php echo e($insight->confidence ? number_format($insight->confidence, 0) . '%' : 'AI'); ?></span>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="list-item">
                    <div>
                        <div class="item-title">No predictions yet</div>
                        <div class="item-sub">Upload telemetry to generate insights.</div>
                    </div>
                    <span class="badge">-</span>
                </div>
            <?php endif; ?>
        </div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Recent Telemetry</div>
            <div class="card-sub">Last 24 hours</div>
        </div>
        <button class="btn btn-ghost">Open Telemetry</button>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Metric</div><div>Value</div><div>Min</div><div>Max</div><div>Status</div><div>Updated</div>
        </div>
        <?php ($telemetryData = $telemetry && is_array($telemetry->data) ? $telemetry->data : []); ?>
        <?php ($fuelRate = $telemetryData['fuel_rate'] ?? null); ?>
        <?php ($engineTemp = $telemetryData['engine_temp'] ?? null); ?>
        <?php ($speed = $telemetryData['speed'] ?? null); ?>
        <div class="table-row">
            <div>Fuel Rate</div>
            <div><?php echo e($fuelRate ? number_format($fuelRate, 0) . ' L/hr' : '-'); ?></div>
            <div>38</div><div>51</div><div><span class="badge badge-live">Normal</span></div>
            <div><?php echo e($telemetry?->timestamp?->diffForHumans() ?? '-'); ?></div>
        </div>
        <div class="table-row">
            <div>Engine Temp</div>
            <div><?php echo e($engineTemp ? number_format($engineTemp, 0) . ' C' : '-'); ?></div>
            <div>72</div><div>92</div><div><span class="badge">Normal</span></div>
            <div><?php echo e($telemetry?->timestamp?->diffForHumans() ?? '-'); ?></div>
        </div>
        <div class="table-row">
            <div>Speed</div>
            <div><?php echo e($speed ? number_format($speed, 0) . ' km/h' : '-'); ?></div>
            <div>0</div><div>50</div><div><span class="badge">Normal</span></div>
            <div><?php echo e($telemetry?->timestamp?->diffForHumans() ?? '-'); ?></div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/vehicle-detail.blade.php ENDPATH**/ ?>