<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Weekly AI Agents Report</title>
    <style>
        body { font-family: "DejaVu Sans", Arial, sans-serif; color: #111827; font-size: 12px; }
        .watermark { position: fixed; top: 25%; left: 15%; width: 70%; opacity: 0.06; z-index: -1; }
        .title-page { text-align: left; margin-bottom: 24px; }
        .header { display: flex; align-items: center; gap: 16px; margin-bottom: 16px; }
        .logo { height: 52px; }
        h1 { font-size: 22px; margin: 0; }
        h2 { font-size: 18px; margin: 24px 0 8px; }
        h3 { font-size: 14px; margin: 16px 0 6px; }
        .subtitle { font-size: 12px; color: #4b5563; }
        .meta { margin-top: 8px; font-size: 12px; color: #374151; }
        .meta-row { display: flex; gap: 8px; margin-top: 4px; }
        .meta-label { min-width: 160px; color: #6b7280; }
        .section { margin-top: 16px; }
        .section-card { border: 1px solid #e5e7eb; border-radius: 8px; padding: 12px; margin-bottom: 12px; }
        .pill { display: inline-block; padding: 2px 8px; border-radius: 999px; font-size: 10px; text-transform: uppercase; }
        .pill.alarm { background: #fee2e2; color: #991b1b; }
        .pill.warn { background: #fef3c7; color: #92400e; }
        .pill.info { background: #e0f2fe; color: #075985; }
        table { width: 100%; border-collapse: collapse; font-size: 11px; margin-top: 8px; }
        th, td { border: 1px solid #e5e7eb; padding: 6px; text-align: left; vertical-align: top; }
        th { background: #111827; color: #fff; }
        ul { margin: 4px 0 8px 16px; padding: 0; }
        .page-break { page-break-after: always; }
        .muted { color: #6b7280; }
        .badge { display: inline-block; font-size: 10px; padding: 2px 6px; border-radius: 6px; background: #f3f4f6; color: #111827; }
    </style>
</head>
<body>
    <?php if($logo): ?>
        <img class="watermark" src="<?php echo e($logo); ?>" alt="Watermark">
    <?php endif; ?>

    <div class="title-page">
        <div class="header">
            <?php if($logo): ?>
                <img class="logo" src="<?php echo e($logo); ?>" alt="Logo">
            <?php endif; ?>
            <div>
                <h1>Weekly AI Agents Report</h1>
                <div class="subtitle"><?php echo e($tenant->name ?? 'Tenant'); ?></div>
                <div class="subtitle">Week <?php echo e($reportWeek); ?> | <?php echo e($periodStart->toDateString()); ?> to <?php echo e($periodEnd->toDateString()); ?> (<?php echo e($timezone); ?>)</div>
            </div>
        </div>
        <div class="meta">
            <div class="meta-row"><span class="meta-label">Generated</span><span><?php echo e(now()->format('Y-m-d H:i')); ?></span></div>
            <div class="meta-row"><span class="meta-label">Report window</span><span><?php echo e($summary['period']['window_mode'] ?? 'last7'); ?></span></div>
        </div>
    </div>

    <?php echo $__env->make('reports.partials.executive_summary', ['executive' => $summary['executive_summary']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="page-break"></div>

    <h2>AI Agent Sections</h2>
    <?php $__currentLoopData = $summary['sections']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo $__env->make('reports.partials.agent_section', ['section' => $section], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="page-break"></div>

    <h2>Maintenance Detail</h2>
    <?php echo $__env->make('reports.partials.maintenance_section', ['maintenance' => $summary['maintenance']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <h2>Finance Detail</h2>
    <?php echo $__env->make('reports.partials.finance_section', ['finance' => $summary['finance']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <h2>HR & Artisan Detail</h2>
    <?php echo $__env->make('reports.partials.hr_section', ['hr' => $summary['hr']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <h2>Ops & Compliance Detail</h2>
    <?php echo $__env->make('reports.partials.ops_section', ['ops' => $summary['ops_notifier']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <h2>Notifications Appendix</h2>
    <?php echo $__env->make('reports.partials.notifications_appendix', ['notifications' => $summary['notifications']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/reports/weekly_ai_agents_report.blade.php ENDPATH**/ ?>