<?php ($active = 'reconciliation'); ?>
<?php ($suggestedCount = $rows->filter(fn ($row) => ($row['link']->status ?? 'suggested') === 'suggested')->count()); ?>
<?php ($appliedCount = $rows->filter(fn ($row) => ($row['link']->status ?? '') === 'applied')->count()); ?>
<?php ($ignoredCount = $rows->filter(fn ($row) => ($row['link']->status ?? '') === 'ignored')->count()); ?>

<?php $__env->startSection('title', 'Reconciliation'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Admin</p>
        <h1>Linking &amp; Reconciliation</h1>
        <p class="sub">Detect and resolve missing links between PRs, POs, GRNs, invoices, and PM work.</p>
    </div>
    <div class="page-actions">
        <form method="POST" action="/ui/reconciliation/run">
            <?php echo csrf_field(); ?>
            <button class="btn btn-ghost" type="submit">Run Engine</button>
        </form>
    </div>
</section>

<section class="grid-3">
    <article class="card">
        <div class="card-title">Suggested Links</div>
        <div class="metric"><?php echo e($suggestedCount); ?></div>
        <div class="metric-sub">Awaiting confirmation</div>
    </article>
    <article class="card">
        <div class="card-title">Applied Links</div>
        <div class="metric"><?php echo e($appliedCount); ?></div>
        <div class="metric-sub">Auto-applied or confirmed</div>
    </article>
    <article class="card">
        <div class="card-title">Ignored Links</div>
        <div class="metric"><?php echo e($ignoredCount); ?></div>
        <div class="metric-sub">Dismissed suggestions</div>
    </article>
</section>

<section class="card filters" data-filter-scope>
    <div class="filter-row">
        <input class="input" placeholder="Search links" data-filter-input />
        <select class="select" data-filter-status>
            <option value="all">Status: All</option>
            <?php $__currentLoopData = $statusOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e(strtolower($status)); ?>"><?php echo e(ucfirst($status)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <select class="select" data-filter-site>
            <option value="all">Link Type: All</option>
            <?php $__currentLoopData = $typeOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($type['value']); ?>"><?php echo e($type['label']); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Reconciliation Queue</div>
            <div class="card-sub">Review and apply safe matches</div>
        </div>
        <div class="chip">Last 200</div>
    </div>
    <div class="table">
        <div class="table-row table-head table-row-7-no-select">
            <div>Type</div><div>Source</div><div>Target</div><div>Confidence</div><div>Status</div><div>Reason</div><div>Action</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php ($link = $row['link']); ?>
            <?php ($status = strtolower($link->status ?? 'suggested')); ?>
            <?php ($badge = $status === 'applied' ? 'badge-live' : ($status === 'suggested' ? 'badge-warning' : 'badge')); ?>
            <?php ($search = strtolower(trim($row['type_label'] . ' ' . $row['source_label'] . ' ' . $row['target_label'] . ' ' . ($link->reason ?? '') . ' ' . $status))); ?>
            <div class="table-row table-row-7-no-select" data-row data-row-id="<?php echo e($link->id); ?>" data-status="<?php echo e($status); ?>" data-site="<?php echo e($row['type_value']); ?>" data-search="<?php echo e($search); ?>">
                <div><?php echo e($row['type_label']); ?></div>
                <div>
                    <?php if($row['source_path']): ?>
                        <a href="<?php echo e($row['source_path']); ?>"><?php echo e($row['source_label']); ?></a>
                    <?php else: ?>
                        <?php echo e($row['source_label']); ?>

                    <?php endif; ?>
                </div>
                <div>
                    <?php if($row['target_path']): ?>
                        <a href="<?php echo e($row['target_path']); ?>"><?php echo e($row['target_label']); ?></a>
                    <?php else: ?>
                        <?php echo e($row['target_label']); ?>

                    <?php endif; ?>
                </div>
                <div><span class="chip"><?php echo e($link->confidence ? number_format($link->confidence * 100, 0) . '%' : '-'); ?></span></div>
                <div><span class="badge <?php echo e($badge); ?>"><?php echo e(ucfirst($status)); ?></span></div>
                <div><?php echo e($link->reason ?? '-'); ?></div>
                <div class="table-actions">
                    <?php if($status === 'suggested'): ?>
                        <form method="POST" action="/ui/reconciliation/<?php echo e($link->id); ?>/apply">
                            <?php echo csrf_field(); ?>
                            <button class="btn btn-primary" type="submit">Apply</button>
                        </form>
                        <form method="POST" action="/ui/reconciliation/<?php echo e($link->id); ?>/ignore">
                            <?php echo csrf_field(); ?>
                            <button class="btn btn-ghost" type="submit">Ignore</button>
                        </form>
                    <?php else: ?>
                        <span class="chip"><?php echo e(ucfirst($status)); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row table-row-7-no-select">
                <div>No reconciliation links yet.</div><div></div><div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/reconciliation.blade.php ENDPATH**/ ?>