
<?php
    $active = 'users';
    $userRecord = \App\Models\User::with(['roles', 'site', 'tenant'])
        ->where('id', $userId)
        ->orWhere('email', $userId)
        ->first();
    $activityLogs = $userRecord
        ? \App\Models\AuditLog::where('tenant_id', $userRecord->tenant_id)
            ->where('user_id', $userRecord->id)
            ->orderByDesc('created_at')
            ->limit(100)
            ->get()
        : collect();
?>

<?php $__env->startSection('title', 'User Details'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">User</p>
        <h1><?php echo e($userRecord?->name ?? ($userId ?? 'User')); ?></h1>
        <p class="sub">Profile, roles, and contact channels.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/users">Back to Users</a>
        <button class="btn btn-primary">Edit User</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Profile</div>
        <div class="list">
            <div class="list-item"><span>Role</span><span class="chip"><?php echo e($userRecord ? ($userRecord->roles->pluck('name')->implode(', ') ?: 'User') : 'User'); ?></span></div>
            <div class="list-item"><span>Site</span><span class="chip"><?php echo e($userRecord?->site?->name ?? 'All Sites'); ?></span></div>
            <div class="list-item"><span>Status</span><span class="badge badge-live">Active</span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Channels</div>
        <div class="list">
            <div class="list-item"><span>Email</span><span class="chip"><?php echo e($userRecord?->email ?? '-'); ?></span></div>
            <div class="list-item"><span>WhatsApp</span><span class="chip"><?php echo e($userRecord?->whatsapp_number ?? '-'); ?></span></div>
            <div class="list-item"><span>Telegram</span><span class="chip"><?php echo e($userRecord?->telegram_handle ?? '-'); ?></span></div>
        </div>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">User Activity</div>
            <div class="card-sub">Latest actions by this user</div>
        </div>
        <div class="chip">Last 100</div>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Action</div><div>Entity</div><div>Changes</div><div>Channel</div><div>Time</div><div>Audit</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $activityLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $entity = trim(($log->entity_type ? ucfirst(str_replace('_', ' ', $log->entity_type)) : '') . ($log->entity_id ? ' #' . $log->entity_id : '')) ?: '-';
                $changes = $log->changes ?? [];
                $changeSummary = '-';
                if (is_array($changes) && $changes) {
                    $parts = [];
                    foreach ($changes as $field => $value) {
                        if (is_array($value)) {
                            $from = $value['from'] ?? ($value[0] ?? '');
                            $to = $value['to'] ?? ($value[1] ?? '');
                            $parts[] = "{$field}: {$from} -> {$to}";
                        } else {
                            $parts[] = "{$field}: {$value}";
                        }
                        if (count($parts) >= 2) {
                            break;
                        }
                    }
                    $changeSummary = implode('; ', $parts);
                }
            ?>
            <div class="table-row">
                <div><?php echo e($log->action ?? 'activity'); ?></div>
                <div><?php echo e($entity); ?></div>
                <div><?php echo e($changeSummary); ?></div>
                <div><?php echo e(strtoupper($log->channel ?? 'web')); ?></div>
                <div><?php echo e($log->created_at?->format('M d H:i') ?? '-'); ?></div>
                <div><a href="/ui/audit/<?php echo e($log->id); ?>">View</a></div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row">
                <div>No activity found.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/user-detail.blade.php ENDPATH**/ ?>