<?php ($active = 'vehicles'); ?>
<?php ($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first()); ?>
<?php ($vehicles = $tenant ? \App\Models\Vehicle::with(['site', 'asset'])->where('tenant_id', $tenant->id)->get() : collect()); ?>
<?php ($vehicles = $vehicles->unique(fn ($vehicle) => $vehicle->asset?->asset_tag ?: ($vehicle->license_plate ?: $vehicle->id))->values()); ?>
<?php ($vehicleCategory = fn ($vehicle) => $vehicle->type ?: ($vehicle->asset?->category ?: 'Uncategorized')); ?>
<?php ($categoryFilter = request('category')); ?>
<?php ($categories = $vehicles->map(fn ($vehicle) => $vehicleCategory($vehicle))->unique()->sort()->values()); ?>
<?php ($filteredVehicles = $categoryFilter && strtolower($categoryFilter) !== 'all' ? $vehicles->filter(fn ($vehicle) => $vehicleCategory($vehicle) === $categoryFilter)->values() : $vehicles); ?>
<?php ($vehicleCount = $filteredVehicles->count()); ?>
<?php ($vehiclesByCategory = $filteredVehicles->groupBy(fn ($vehicle) => $vehicleCategory($vehicle))); ?>

<?php $__env->startSection('title', 'Fleet'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Fleet</p>
        <h1>Vehicle Operations</h1>
        <p class="sub">Track utilization, driver shifts, and telemetry integrity.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Assign Driver</button>
        <button class="btn btn-primary">Add Vehicle</button>
    </div>
</section>

<section class="card filters">
    <form class="filter-row" method="get">
        <input class="input" name="q" value="<?php echo e(request('q')); ?>" placeholder="Search fleet" />
        <select class="select" name="site">
            <option value="">All Sites</option>
            <option>North Ridge</option>
            <option>East Yard</option>
        </select>
        <select class="select" name="status">
            <option value="">Status: Any</option>
            <option>Active</option>
            <option>Service</option>
        </select>
        <select class="select" name="category">
            <option value="all" <?php if(!$categoryFilter || strtolower($categoryFilter) === 'all'): echo 'selected'; endif; ?>>All Categories</option>
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($category); ?>" <?php if($categoryFilter === $category): echo 'selected'; endif; ?>><?php echo e($category); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <button class="btn btn-ghost" type="submit">Apply</button>
        <a class="btn btn-ghost" href="/ui/vehicles">Reset</a>
    </form>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Fleet Utilization Trend</div>
                <div class="card-sub">Average shift readiness</div>
            </div>
            <div class="chip">Last 12 weeks</div>
        </div>
        <div class="trend-chart">
            <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                <path class="trend-fill" d="M0 90 L40 82 L80 76 L120 70 L160 64 L200 58 L240 54 L260 48 L260 120 L0 120 Z"></path>
                <polyline class="trend-line" points="0,90 40,82 80,76 120,70 160,64 200,58 240,54 260,48"></polyline>
                <circle class="trend-dot" cx="80" cy="76" r="3"></circle>
                <circle class="trend-dot" cx="160" cy="64" r="3"></circle>
                <circle class="trend-dot" cx="240" cy="54" r="3"></circle>
            </svg>
        </div>
        <div class="trend-legend">
            <span>Utilization 72-86%</span>
            <span>Idle time 9.4h</span>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Fuel Burn by Class</div>
                <div class="card-sub">Average L/hr</div>
            </div>
            <div class="chip">Shift A</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 72%"><span>Haulers</span></div>
                <div class="chart-bar" style="--value: 56%"><span>Loaders</span></div>
                <div class="chart-bar" style="--value: 48%"><span>Tippers</span></div>
                <div class="chart-bar" style="--value: 36%"><span>Support</span></div>
            </div>
        </div>
    </article>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Fleet Status</div>
            <div class="card-sub"><?php echo e($vehicleCount); ?> vehicles online</div>
        </div>
        <div class="chip">Shift A</div>
    </div>

    <div class="table">
        <div class="table-row table-head">
            <div>Vehicle</div><div>Name</div><div>Category</div><div>Site</div><div>Status</div><div>Telemetry</div><div>Fuel</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $vehiclesByCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="table-row">
                <div><strong><?php echo e($category); ?></strong></div>
                <div><?php echo e($group->count()); ?> vehicles</div>
                <div></div><div></div><div></div><div></div><div></div>
            </div>
            <?php $__currentLoopData = $group; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php ($fuelRate = is_array($vehicle->telemetry_data) ? ($vehicle->telemetry_data['fuel_rate'] ?? null) : null); ?>
                <a class="table-row" href="/ui/vehicles/<?php echo e($vehicle->id); ?>">
                    <div class="media-cell">
                        <img class="thumb" src="/ui-assets/images/vehicle-hauler.svg" alt="<?php echo e($vehicle->name); ?>">
                        <div><?php echo e($vehicle->asset?->asset_tag ?? ('V-' . $vehicle->id)); ?></div>
                    </div>
                    <div><?php echo e($vehicle->name); ?></div>
                    <div><?php echo e($vehicleCategory($vehicle)); ?></div>
                    <div><?php echo e($vehicle->site?->name ?? 'Unassigned'); ?></div>
                    <div><span class="badge <?php echo e($vehicle->status === 'service' ? 'badge-warning' : 'badge-live'); ?>"><?php echo e(ucfirst($vehicle->status)); ?></span></div>
                    <div><?php echo e($vehicle->status === 'service' ? 'Degraded' : 'Stable'); ?></div>
                    <div><?php echo e($fuelRate ? number_format($fuelRate, 0) . ' L/hr' : '-'); ?></div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row">
                <div>No vehicles available.</div><div></div><div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/vehicles.blade.php ENDPATH**/ ?>