
<?php ($active = 'trips'); ?>
<?php ($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first()); ?>
<?php ($trips = $tenant ? \App\Models\Trip::with('vehicle')->where('tenant_id', $tenant->id)->latest()->get() : collect()); ?>
<?php ($liveTrips = $trips->whereNull('end_time')->take(2)); ?>
<?php ($recentTrips = $trips->take(5)); ?>

<?php $__env->startSection('title', 'Trips'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Trips</p>
        <h1>Trip Intelligence</h1>
        <p class="sub">Monitor route performance and turnaround times.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Optimize Routes</button>
        <button class="btn btn-primary">Create Trip</button>
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Trip Volume Trend</div>
                <div class="card-sub">Completed trips per week</div>
            </div>
            <div class="chip">Last 8 weeks</div>
        </div>
        <div class="chart-placeholder chart-placeholder--bars">
            <div class="chart-bars">
                <div class="chart-bar" style="--value: 54%"><span>W1</span></div>
                <div class="chart-bar" style="--value: 62%"><span>W2</span></div>
                <div class="chart-bar" style="--value: 58%"><span>W3</span></div>
                <div class="chart-bar" style="--value: 70%"><span>W4</span></div>
                <div class="chart-bar" style="--value: 76%"><span>W5</span></div>
                <div class="chart-bar" style="--value: 74%"><span>W6</span></div>
                <div class="chart-bar" style="--value: 82%"><span>W7</span></div>
                <div class="chart-bar" style="--value: 88%"><span>W8</span></div>
            </div>
        </div>
    </article>
    <article class="card">
        <div class="card-head">
            <div>
                <div class="card-title">Turnaround Time</div>
                <div class="card-sub">Average minutes per haul</div>
            </div>
            <div class="chip">Target 18m</div>
        </div>
        <div class="trend-chart">
            <svg viewBox="0 0 260 120" preserveAspectRatio="none" aria-hidden="true">
                <path class="trend-fill" d="M0 70 L40 78 L80 72 L120 66 L160 60 L200 64 L240 58 L260 54 L260 120 L0 120 Z"></path>
                <polyline class="trend-line" points="0,70 40,78 80,72 120,66 160,60 200,64 240,58 260,54"></polyline>
                <circle class="trend-dot" cx="80" cy="72" r="3"></circle>
                <circle class="trend-dot" cx="160" cy="60" r="3"></circle>
                <circle class="trend-dot" cx="260" cy="54" r="3"></circle>
            </svg>
        </div>
        <div class="trend-legend">
            <span>Avg 19.6m</span>
            <span>Idle 2.4m</span>
        </div>
    </article>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-title">Live Trips</div>
        <div class="timeline">
            <?php $__empty_1 = true; $__currentLoopData = $liveTrips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="timeline-item">
                    <div class="timeline-time"><?php echo e($trip->start_time?->format('H:i') ?? '-'); ?></div>
                    <div>
                        <div class="item-title"><a href="/ui/trips/<?php echo e($trip->id); ?>"><?php echo e($trip->start_location); ?> -> <?php echo e($trip->end_location ?? 'In transit'); ?></a></div>
                        <div class="item-sub"><?php echo e($trip->vehicle?->name ?? 'Vehicle'); ?> | ETA <?php echo e(rand(4, 18)); ?>m</div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="timeline-item">
                    <div class="timeline-time">-</div>
                    <div>
                        <div class="item-title">No live trips</div>
                        <div class="item-sub">All vehicles are idle.</div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </article>

    <article class="card">
        <div class="card-title">Trip Performance</div>
        <div class="chart-placeholder">Route Efficiency</div>
        <div class="legend">
            <span class="legend-item">Average Time</span>
            <span class="legend-item">Idle</span>
        </div>
    </article>
</section>

<section class="card">
    <div class="card-title">Recent Trips</div>
    <div class="table">
        <div class="table-row table-head">
            <div>ID</div><div>Vehicle</div><div>Route</div><div>Distance</div><div>Status</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $recentTrips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <a class="table-row" href="/ui/trips/<?php echo e($trip->id); ?>">
                <div><?php echo e($trip->id); ?></div>
                <div><?php echo e($trip->vehicle?->name ?? 'Vehicle'); ?></div>
                <div><?php echo e($trip->start_location); ?> -> <?php echo e($trip->end_location ?? 'In transit'); ?></div>
                <div><?php echo e($trip->distance ? number_format($trip->distance, 1) . ' km' : '-'); ?></div>
                <div><span class="badge <?php echo e($trip->status === 'completed' ? 'badge-live' : 'badge-warning'); ?>"><?php echo e(ucfirst($trip->status)); ?></span></div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row">
                <div>No trips available.</div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/trips.blade.php ENDPATH**/ ?>