<?php
    $active = 'audit';
    $tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::first();
    $logs = $tenant
        ? \App\Models\AuditLog::with('user')->where('tenant_id', $tenant->id)->orderByDesc('created_at')->limit(200)->get()
        : collect();
    $actionOptions = $logs->pluck('action')->filter()->unique()->values();
    $channelOptions = $logs->pluck('channel')->filter()->unique()->values();
?>

<?php $__env->startSection('title', 'Audit Log'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Security</p>
        <h1>Audit Log</h1>
        <p class="sub">Track who changed what and when.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/exports/audit-log.pdf">Export</a>
        <button class="btn btn-primary">Filter</button>
    </div>
</section>

<section class="card filters" data-filter-scope>
    <div class="filter-row">
        <input class="input" placeholder="Search activity" data-filter-input />
        <select class="select" data-filter-status>
            <option value="all">Action: All</option>
            <?php $__currentLoopData = $actionOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e(strtolower($action)); ?>"><?php echo e($action); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <select class="select" data-filter-site>
            <option value="all">Channel: All</option>
            <?php $__currentLoopData = $channelOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $channel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e(strtolower($channel)); ?>"><?php echo e(strtoupper($channel)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Recent Activity</div>
            <div class="card-sub">Tenant-wide changes</div>
        </div>
        <div class="chip">Last 200</div>
    </div>
    <div class="table">
        <div class="table-row table-head">
            <div>Actor</div><div>Action</div><div>Entity</div><div>Changes</div><div>IP</div><div>Time</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $actor = $log->user?->name ?? 'System';
                $entity = trim(($log->entity_type ? ucfirst(str_replace('_', ' ', $log->entity_type)) : '') . ($log->entity_id ? ' #' . $log->entity_id : '')) ?: '-';
                $changes = $log->changes ?? [];
                $changeSummary = '-';
                if (is_array($changes) && $changes) {
                    $parts = [];
                    foreach ($changes as $field => $value) {
                        if (is_array($value)) {
                            $from = $value['from'] ?? ($value[0] ?? '');
                            $to = $value['to'] ?? ($value[1] ?? '');
                            $parts[] = "{$field}: {$from} -> {$to}";
                        } else {
                            $parts[] = "{$field}: {$value}";
                        }
                        if (count($parts) >= 2) {
                            break;
                        }
                    }
                    $changeSummary = implode('; ', $parts);
                }
                $action = $log->action ?? 'activity';
                $channel = $log->channel ?? 'web';
                $search = strtolower($actor . ' ' . $action . ' ' . $entity . ' ' . $changeSummary . ' ' . $channel);
            ?>
            <a class="table-row" href="/ui/audit/<?php echo e($log->id); ?>" data-row data-row-id="<?php echo e($log->id); ?>" data-status="<?php echo e(strtolower($action)); ?>" data-site="<?php echo e(strtolower($channel)); ?>" data-search="<?php echo e($search); ?>">
                <div><?php echo e($actor); ?></div><div><?php echo e($action); ?></div><div><?php echo e($entity); ?></div><div><?php echo e($changeSummary); ?></div><div><?php echo e($log->ip_address ?? '-'); ?></div><div><?php echo e($log->created_at?->format('M d H:i') ?? '-'); ?></div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row">
                <div>No audit entries yet.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/audit.blade.php ENDPATH**/ ?>