
<?php ($active = 'purchase-requests'); ?>
<?php ($request = \App\Models\PurchaseRequest::with(['items.documents', 'site'])->where('id', $requestId)->orWhere('request_code', $requestId)->first()); ?>
<?php ($items = $request ? $request->items : collect()); ?>

<?php $__env->startSection('title', 'Purchase Request Details'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Purchase Request</p>
        <h1><?php echo e($request?->request_code ?? 'PR'); ?> - <?php echo e($request?->title ?? 'Procurement Request'); ?></h1>
        <p class="sub">Request details, approvals, and sourcing notes.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/purchase-requests">Back to Requests</a>
        <?php if($request): ?>
            <a class="btn btn-ghost" href="/exports/purchase-requests/<?php echo e($request->id); ?>/pdf">Download PDF</a>
            <a class="btn btn-ghost" href="/exports/purchase-requests/<?php echo e($request->id); ?>/excel">Download Excel</a>
        <?php endif; ?>
        <button class="btn btn-primary">Convert to PO</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Request Summary</div>
        <div class="list">
            <div class="list-item"><span>Site</span><span class="chip"><?php echo e($request?->site?->name ?? 'Unassigned'); ?></span></div>
            <div class="list-item"><span>Category</span><span class="chip"><?php echo e($request?->title ?? 'Procurement'); ?></span></div>
            <div class="list-item"><span>Requested By</span><span class="chip"><?php echo e($request?->requested_by ? 'User ' . $request->requested_by : 'System Import'); ?></span></div>
            <div class="list-item"><span>Priority</span><span class="badge badge-warning"><?php echo e(ucfirst($request?->priority ?? 'medium')); ?></span></div>
            <div class="list-item"><span>Status</span><span class="badge"><?php echo e(ucfirst($request?->status ?? 'pending')); ?></span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Budget Impact</div>
        <div class="metric"><?php echo e($request?->total_estimated_cost !== null ? '$' . number_format($request->total_estimated_cost, 0) : '-'); ?></div>
        <div class="metric-sub">Budget remaining: $120,000</div>
        <div class="cost-row"><span>Parts</span><span class="chip">$22,900</span></div>
        <div class="cost-row"><span>Logistics</span><span class="chip">$3,200</span></div>
        <div class="cost-row"><span>Contingency</span><span class="chip">$2,300</span></div>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Requested Items</div>
            <div class="card-sub"><?php echo e($items->count()); ?> line items</div>
        </div>
        <button class="btn btn-ghost">Add Item</button>
    </div>
    <div class="table">
        <div class="table-row table-head table-row-7-no-select">
            <div>Item</div><div>Qty</div><div>Unit</div><div>Est. Cost</div><div>Supplier</div><div>Status</div><div>Actions</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php ($quoted = $item->quote_amount_usd || $item->quote_amount_zwl); ?>
            <div class="table-row table-row-7-no-select"
                data-pr-item
                data-item-id="<?php echo e($item->id); ?>"
                data-item-name="<?php echo e($item->item_name); ?>"
                data-item-qty="<?php echo e($item->quantity); ?>"
                data-item-unit="<?php echo e($item->unit); ?>"
                data-item-purpose="<?php echo e($item->purpose_cost_center); ?>"
                data-item-supplier="<?php echo e($item->supplier_name); ?>"
                data-item-selected="<?php echo e($item->selected_supplier); ?>"
                data-item-usd="<?php echo e($item->quote_amount_usd); ?>"
                data-item-zwl="<?php echo e($item->quote_amount_zwl); ?>"
                data-item-comments="<?php echo e($item->comments); ?>"
            >
                <div><?php echo e($item->item_name ?? 'Item'); ?></div>
                <div><?php echo e($item->quantity !== null ? number_format($item->quantity, 0) : '-'); ?></div>
                <div><?php echo e($item->unit ?? '-'); ?></div>
                <div>
                    <?php if($item->quote_amount_usd !== null): ?>
                        $<?php echo e(number_format($item->quote_amount_usd, 0)); ?>

                    <?php elseif($item->quote_amount_zwl !== null): ?>
                        ZWL <?php echo e(number_format($item->quote_amount_zwl, 0)); ?>

                    <?php else: ?>
                        -
                    <?php endif; ?>
                </div>
                <div><?php echo e($item->selected_supplier ?? $item->supplier_name ?? '-'); ?></div>
                <div><span class="badge <?php echo e($quoted ? 'badge-live' : 'badge'); ?>"><?php echo e($quoted ? 'Quoted' : 'Pending'); ?></span></div>
                <div class="table-actions">
                    <button class="btn btn-ghost btn-sm" type="button" data-pr-item-view="<?php echo e($item->id); ?>">View</button>
                    <button class="btn btn-ghost btn-sm" type="button" data-pr-item-edit="<?php echo e($item->id); ?>">Edit</button>
                    <button class="btn btn-ghost btn-sm" type="button" data-pr-item-attach="<?php echo e($item->id); ?>">Attach</button>
                </div>
            </div>
            <div class="pr-item-details" data-pr-item-details="<?php echo e($item->id); ?>" hidden>
                <div class="pr-item-details-card">
                    <div>
                        <div class="card-title">Line Item Details</div>
                        <div class="card-sub"><?php echo e($item->purpose_cost_center ?? 'No cost center'); ?></div>
                    </div>
                    <div class="pr-item-docs">
                        <div class="card-title">Attachments</div>
                        <ul class="pr-doc-list" data-pr-doc-list="<?php echo e($item->id); ?>">
                            <?php $__empty_2 = true; $__currentLoopData = $item->documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                <li><a href="<?php echo e(route('purchase-request-item-documents.download', [$item->id, $doc->id])); ?>"><?php echo e($doc->original_name); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                <li>No attachments yet.</li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row table-row-7-no-select">
                <div>No items found.</div><div></div><div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>

<section class="grid-2">
    <article class="card">
        <div class="card-title">Approvals</div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Maintenance Manager</div>
                    <div class="item-sub">Awaiting approval</div>
                </div>
                <span class="badge badge-warning">Pending</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Finance</div>
                    <div class="item-sub">Auto-approval required</div>
                </div>
                <span class="badge">Not started</span>
            </div>
        </div>
    </article>
    <article class="card">
        <div class="card-title">Sourcing Notes</div>
        <div class="list">
            <div class="list-item">
                <div>
                    <div class="item-title">Lead time 5 days</div>
                    <div class="item-sub">Priority shipping recommended</div>
                </div>
                <span class="badge badge-live">On Track</span>
            </div>
            <div class="list-item">
                <div>
                    <div class="item-title">Budget variance</div>
                    <div class="item-sub">+4% vs last quarter average</div>
                </div>
                <span class="badge badge-warning">Review</span>
            </div>
        </div>
    </article>
</section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/purchase-request-detail.blade.php ENDPATH**/ ?>