<div class="section-card">
    <div class="section">
        <strong>Notification Summary by Channel</strong>
        <?php if(!empty($notifications['by_channel'])): ?>
            <table>
                <thead>
                    <tr>
                        <th>Channel</th>
                        <th>Queued</th>
                        <th>Sent</th>
                        <th>Failed</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $notifications['by_channel']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(strtoupper((string) $row['channel'])); ?></td>
                            <td><?php echo e($row['queued']); ?></td>
                            <td><?php echo e($row['sent']); ?></td>
                            <td><?php echo e($row['failed']); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="muted">No notification activity captured.</div>
        <?php endif; ?>
    </div>

    <div class="section">
        <strong>Notification Summary by Severity</strong>
        <?php if(!empty($notifications['by_severity'])): ?>
            <table>
                <thead>
                    <tr>
                        <th>Severity</th>
                        <th>Count</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $notifications['by_severity']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(strtoupper($row['severity'])); ?></td>
                            <td><?php echo e($row['count']); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="muted">No severity summary available.</div>
        <?php endif; ?>
    </div>

    <div class="section">
        <strong>ALARM Escalations</strong>
        <?php if(!empty($notifications['alarm_escalations'])): ?>
            <ul>
                <?php $__currentLoopData = $notifications['alarm_escalations']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($row['title']); ?> (<?php echo e(strtoupper($row['channel'])); ?> - <?php echo e($row['status']); ?>): <?php echo e($row['message']); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php else: ?>
            <div class="muted">No alarm escalations recorded.</div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/reports/partials/notifications_appendix.blade.php ENDPATH**/ ?>