<?php
    $activeTab = $active ?? '';
    $overviewTabs = ['dashboard', 'kpis', 'alerts', 'alarm-rules'];
    $operationsTabs = ['assets', 'vehicles', 'trips', 'maintenance', 'work-orders', 'pm-schedules', 'checklists', 'downtime', 'fuel', 'tyres', 'telemetry', 'sites'];
    $supplyTabs = ['inventory', 'vendors', 'purchase-requests', 'purchase-orders', 'payments'];
    $dataTabs = ['imports', 'devices'];
    $intelligenceTabs = ['ai', 'agent-notifications', 'reports'];
    $adminTabs = ['tenants', 'users', 'roles', 'reconciliation', 'notifications', 'audit', 'settings'];
    $overviewExpanded = $activeTab ? in_array($activeTab, $overviewTabs, true) : true;
?>
<aside class="sidebar">
    <div class="sidebar-brand">
        <a class="logo" href="/ui" aria-label="Open dashboard">
            <span class="logo-mark">T</span>
            <div class="logo-text">
                <div class="logo-title">TAMS</div>
                <div class="logo-sub">Asset Management</div>
            </div>
        </a>

        <div class="tenant-card">
            <div class="tenant-header">
                <img class="tenant-logo" src="/ui-assets/images/tenant-iron-ridge.svg" alt="Fourways Group logo">
                <div>
                    <div class="tenant-title">Fourways Group</div>
                    <div class="tenant-meta">Enterprise Plan</div>
                </div>
            </div>
            <div class="tenant-badges">
                <span class="badge badge-live">Live</span>
                <span class="badge badge-ai">AI On</span>
            </div>
        </div>
    </div>

    <nav class="nav">
        <div class="nav-group <?php echo e($overviewExpanded ? '' : 'is-collapsed'); ?>">
            <button class="nav-label" type="button" data-nav-toggle>
                <span class="nav-label-icon">
                    <svg viewBox="0 0 24 24" aria-hidden="true">
                        <rect x="3" y="3" width="7" height="7" rx="1.5"></rect>
                        <rect x="14" y="3" width="7" height="7" rx="1.5"></rect>
                        <rect x="3" y="14" width="7" height="7" rx="1.5"></rect>
                        <rect x="14" y="14" width="7" height="7" rx="1.5"></rect>
                    </svg>
                </span>
                Overview
                <span class="nav-chevron" aria-hidden="true">
                    <svg viewBox="0 0 24 24"><path d="M6 9l6 6 6-6"></path></svg>
                </span>
            </button>
            <div class="nav-sub">
                <a class="nav-item <?php echo e(($active ?? '') === 'dashboard' ? 'is-active' : ''); ?>" href="/ui">Dashboard</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'kpis' ? 'is-active' : ''); ?>" href="/ui/kpis">KPI Studio</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'alerts' ? 'is-active' : ''); ?>" href="/ui/alerts">Alerts</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'alarm-rules' ? 'is-active' : ''); ?>" href="/ui/alarm-rules">Alarm Rules</a>
            </div>
        </div>

        <div class="nav-group <?php echo e(in_array($activeTab, $operationsTabs, true) ? '' : 'is-collapsed'); ?>">
            <button class="nav-label" type="button" data-nav-toggle>
                <span class="nav-label-icon">
                    <svg viewBox="0 0 24 24" aria-hidden="true">
                        <circle cx="12" cy="12" r="4"></circle>
                        <path d="M12 2v3M12 19v3M2 12h3M19 12h3M4.9 4.9l2.1 2.1M17 17l2.1 2.1M17 7l2.1-2.1M4.9 19.1l2.1-2.1"></path>
                    </svg>
                </span>
                Operations
                <span class="nav-chevron" aria-hidden="true">
                    <svg viewBox="0 0 24 24"><path d="M6 9l6 6 6-6"></path></svg>
                </span>
            </button>
            <div class="nav-sub">
                <a class="nav-item <?php echo e(($active ?? '') === 'assets' ? 'is-active' : ''); ?>" href="/ui/assets">Assets</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'vehicles' ? 'is-active' : ''); ?>" href="/ui/vehicles">Fleet</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'trips' ? 'is-active' : ''); ?>" href="/ui/trips">Trips</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'maintenance' ? 'is-active' : ''); ?>" href="/ui/maintenance">Maintenance</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'work-orders' ? 'is-active' : ''); ?>" href="/ui/work-orders">Work Orders</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'pm-schedules' ? 'is-active' : ''); ?>" href="/ui/pm-schedules">PM Schedules</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'checklists' ? 'is-active' : ''); ?>" href="/ui/checklists">Checklists</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'downtime' ? 'is-active' : ''); ?>" href="/ui/downtime">Downtime</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'fuel' ? 'is-active' : ''); ?>" href="/ui/fuel">Fuel</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'tyres' ? 'is-active' : ''); ?>" href="/ui/tyres">Tyres</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'telemetry' ? 'is-active' : ''); ?>" href="/ui/telemetry">Telemetry</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'sites' ? 'is-active' : ''); ?>" href="/ui/sites">Sites</a>
            </div>
        </div>

        <div class="nav-group <?php echo e(in_array($activeTab, $supplyTabs, true) ? '' : 'is-collapsed'); ?>">
            <button class="nav-label" type="button" data-nav-toggle>
                <span class="nav-label-icon">
                    <svg viewBox="0 0 24 24" aria-hidden="true">
                        <path d="M3 7l9-4 9 4-9 4-9-4z"></path>
                        <path d="M3 7v10l9 4 9-4V7"></path>
                        <path d="M12 11v10"></path>
                    </svg>
                </span>
                Supply Chain
                <span class="nav-chevron" aria-hidden="true">
                    <svg viewBox="0 0 24 24"><path d="M6 9l6 6 6-6"></path></svg>
                </span>
            </button>
            <div class="nav-sub">
                <a class="nav-item <?php echo e(($active ?? '') === 'inventory' ? 'is-active' : ''); ?>" href="/ui/inventory">Inventory</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'vendors' ? 'is-active' : ''); ?>" href="/ui/vendors">Vendors</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'purchase-requests' ? 'is-active' : ''); ?>" href="/ui/purchase-requests">Purchase Requests</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'purchase-orders' ? 'is-active' : ''); ?>" href="/ui/purchase-orders">Purchase Orders</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'payments' ? 'is-active' : ''); ?>" href="/ui/payments">Payments</a>
            </div>
        </div>

        <div class="nav-group <?php echo e(in_array($activeTab, $dataTabs, true) ? '' : 'is-collapsed'); ?>">
            <button class="nav-label" type="button" data-nav-toggle>
                <span class="nav-label-icon">
                    <svg viewBox="0 0 24 24" aria-hidden="true">
                        <ellipse cx="12" cy="5" rx="8" ry="3"></ellipse>
                        <path d="M4 5v6c0 1.7 3.6 3 8 3s8-1.3 8-3V5"></path>
                        <path d="M4 11v6c0 1.7 3.6 3 8 3s8-1.3 8-3v-6"></path>
                    </svg>
                </span>
                Data
                <span class="nav-chevron" aria-hidden="true">
                    <svg viewBox="0 0 24 24"><path d="M6 9l6 6 6-6"></path></svg>
                </span>
            </button>
            <div class="nav-sub">
                <a class="nav-item <?php echo e(($active ?? '') === 'imports' ? 'is-active' : ''); ?>" href="/ui/imports">Imports</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'devices' ? 'is-active' : ''); ?>" href="/ui/devices">Devices</a>
            </div>
        </div>

        <div class="nav-group <?php echo e(in_array($activeTab, $intelligenceTabs, true) ? '' : 'is-collapsed'); ?>">
            <button class="nav-label" type="button" data-nav-toggle>
                <span class="nav-label-icon">
                    <svg viewBox="0 0 24 24" aria-hidden="true">
                        <path d="M12 3l2.4 4.8L20 9l-4 3.6L17 18l-5-2.6L7 18l1-5.4L4 9l5.6-1.2L12 3z"></path>
                    </svg>
                </span>
                Intelligence
                <span class="nav-chevron" aria-hidden="true">
                    <svg viewBox="0 0 24 24"><path d="M6 9l6 6 6-6"></path></svg>
                </span>
            </button>
            <div class="nav-sub">
                <a class="nav-item <?php echo e(($active ?? '') === 'ai' ? 'is-active' : ''); ?>" href="/ui/ai">AI Automation</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'agent-notifications' ? 'is-active' : ''); ?>" href="/ui/agent-notifications">AI Agents Log</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'reports' ? 'is-active' : ''); ?>" href="/ui/reports">Reports</a>
            </div>
        </div>

        <div class="nav-group <?php echo e(in_array($activeTab, $adminTabs, true) ? '' : 'is-collapsed'); ?>">
            <button class="nav-label" type="button" data-nav-toggle>
                <span class="nav-label-icon">
                    <svg viewBox="0 0 24 24" aria-hidden="true">
                        <path d="M12 3l7 3v6c0 5-3.5 8-7 9-3.5-1-7-4-7-9V6l7-3z"></path>
                    </svg>
                </span>
                Admin
                <span class="nav-chevron" aria-hidden="true">
                    <svg viewBox="0 0 24 24"><path d="M6 9l6 6 6-6"></path></svg>
                </span>
            </button>
            <div class="nav-sub">
                <a class="nav-item <?php echo e(($active ?? '') === 'tenants' ? 'is-active' : ''); ?>" href="/ui/tenants">Tenants</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'users' ? 'is-active' : ''); ?>" href="/ui/users">Users</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'roles' ? 'is-active' : ''); ?>" href="/ui/roles">Roles</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'reconciliation' ? 'is-active' : ''); ?>" href="/ui/reconciliation">Reconciliation</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'notifications' ? 'is-active' : ''); ?>" href="/ui/notifications">Notifications</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'audit' ? 'is-active' : ''); ?>" href="/ui/audit">Audit Log</a>
                <a class="nav-item <?php echo e(($active ?? '') === 'settings' ? 'is-active' : ''); ?>" href="/ui/settings">Settings</a>
            </div>
        </div>
    </nav>

    <div class="sidebar-footer">
        <div class="support-card">
            <div class="support-title">Need help?</div>
            <div class="support-text">Chat with a fleet specialist 24/7.</div>
            <button class="btn btn-ghost" data-action-label="Open Support">Open support</button>
        </div>
        <div class="sidebar-note">Developed by Tek1 Asset Management Solutions</div>
    </div>
</aside>


<?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/partials/sidebar.blade.php ENDPATH**/ ?>