<?php ($active = 'users'); ?>
<?php ($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::first()); ?>
<?php ($users = $tenant ? \App\Models\User::with(['roles', 'site'])->where('tenant_id', $tenant->id)->orderBy('name')->get() : collect()); ?>

<?php $__env->startSection('title', 'Users'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Users</p>
        <h1>Team Access</h1>
        <p class="sub">Manage roles, permissions, and shift coverage.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Sync HRIS</button>
        <button class="btn btn-primary">Invite User</button>
    </div>
</section>

<section class="card">
    <div class="table">
        <div class="table-row table-head">
            <div>Name</div><div>Role</div><div>Site</div><div>Status</div><div>Last Active</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <a class="table-row" href="/ui/users/<?php echo e($user->id); ?>">
                <div><?php echo e($user->name); ?></div>
                <div><?php echo e($user->roles->pluck('name')->implode(', ') ?: 'User'); ?></div>
                <div><?php echo e($user->site?->name ?? 'All Sites'); ?></div>
                <div><span class="badge badge-live">Active</span></div>
                <div><?php echo e($user->updated_at?->diffForHumans() ?? 'Recently'); ?></div>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row">
                <div>No users found.</div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/users.blade.php ENDPATH**/ ?>