
<?php ($active = 'inventory'); ?>
<?php ($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first()); ?>
<?php ($item = $tenant ? \App\Models\InventoryItem::with(['part', 'location'])->where('tenant_id', $tenant->id)->where('id', $itemId)->first() : null); ?>

<?php $__env->startSection('title', 'Inventory Details'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Inventory Item</p>
        <h1><?php echo e($item?->part?->name ?? 'Item'); ?> - <?php echo e($item?->part?->sku ?? $itemId ?? 'SKU'); ?></h1>
        <p class="sub">Stock levels, reorder status, and usage.</p>
    </div>
    <div class="page-actions">
        <a class="btn btn-ghost" href="/ui/inventory">Back to Inventory</a>
        <button class="btn btn-primary">Adjust Stock</button>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Item Profile</div>
        <div class="list">
            <div class="list-item"><span>Part</span><span class="chip"><?php echo e($item?->part?->name ?? '-'); ?></span></div>
            <div class="list-item"><span>Location</span><span class="chip"><?php echo e($item?->location?->name ?? 'Main Store'); ?></span></div>
            <div class="list-item"><span>On Hand</span><span class="badge <?php echo e(($item?->min_quantity !== null && $item?->quantity <= $item?->min_quantity) ? 'badge-warning' : 'badge-live'); ?>"><?php echo e($item?->quantity ?? 0); ?></span></div>
            <div class="list-item"><span>Reorder Point</span><span class="chip"><?php echo e($item?->reorder_point ?? $item?->min_quantity ?? '-'); ?></span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Usage</div>
        <div class="list">
            <div class="list-item"><span>Last 30 days</span><span class="chip">24</span></div>
            <div class="list-item"><span>Open WOs</span><span class="chip">3</span></div>
            <div class="list-item"><span>Lead Time</span><span class="chip">5 days</span></div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/inventory-detail.blade.php ENDPATH**/ ?>