<div class="section-card">
    <h2>Executive Summary</h2>
    <div class="section">
        <h3>Headline KPIs</h3>
        <table>
            <thead>
                <tr>
                    <th>Availability</th>
                    <th>Utilization</th>
                    <th>MTBF</th>
                    <th>Fuel Efficiency</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo e($executive['headline_kpis']['availability'] !== null ? number_format($executive['headline_kpis']['availability'], 1) . '%' : 'N/A'); ?></td>
                    <td><?php echo e($executive['headline_kpis']['utilization'] !== null ? number_format($executive['headline_kpis']['utilization'], 1) . '%' : 'N/A'); ?></td>
                    <td><?php echo e($executive['headline_kpis']['mtbf'] !== null ? $executive['headline_kpis']['mtbf'] . 'h' : 'N/A'); ?></td>
                    <td><?php echo e($executive['headline_kpis']['fuel_efficiency'] !== null ? number_format($executive['headline_kpis']['fuel_efficiency'], 2) . ' L/hr' : 'N/A'); ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="section">
        <h3>Top Risks</h3>
        <?php if(!empty($executive['top_risks'])): ?>
            <ul>
                <?php $__currentLoopData = $executive['top_risks']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $risk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($risk); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php else: ?>
            <div class="muted">No major risks recorded.</div>
        <?php endif; ?>
    </div>

    <div class="section">
        <h3>Top Wins</h3>
        <?php if(!empty($executive['top_wins'])): ?>
            <ul>
                <?php $__currentLoopData = $executive['top_wins']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $win): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($win); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php else: ?>
            <div class="muted">No wins recorded.</div>
        <?php endif; ?>
    </div>

    <div class="section">
        <h3>Finance Highlights</h3>
        <table>
            <thead>
                <tr>
                    <th>Total Spend (MTD)</th>
                    <th>Spend vs Budget</th>
                    <th>Unpaid Total</th>
                    <th>PR Aging</th>
                    <th>PO Aging</th>
                    <th>Invoice Aging</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo e($executive['total_spend'] !== null ? '$' . number_format($executive['total_spend'], 2) : 'N/A'); ?></td>
                    <td><?php echo e($executive['spend_vs_budget'] !== null ? number_format($executive['spend_vs_budget'], 1) . '%' : 'N/A'); ?></td>
                    <td><?php echo e($executive['unpaid_total'] !== null ? '$' . number_format($executive['unpaid_total'], 2) : 'N/A'); ?></td>
                    <td><?php echo e($executive['pr_aging_days'] !== null ? number_format($executive['pr_aging_days'], 1) . ' days' : 'N/A'); ?></td>
                    <td><?php echo e($executive['po_aging_days'] !== null ? number_format($executive['po_aging_days'], 1) . ' days' : 'N/A'); ?></td>
                    <td><?php echo e($executive['invoice_aging_days'] !== null ? number_format($executive['invoice_aging_days'], 1) . ' days' : 'N/A'); ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <?php if(!empty($executive['data_confidence'])): ?>
        <div class="section">
            <h3>Data Confidence Notes</h3>
            <ul>
                <?php $__currentLoopData = $executive['data_confidence']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($note); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
</div>
<?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/reports/partials/executive_summary.blade.php ENDPATH**/ ?>