<?php
    $active = 'agent-notifications';
?>

<?php $__env->startSection('title', 'Agent Notification Detail'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Intelligence</p>
        <h1><?php echo e($notification->title); ?></h1>
        <p class="sub"><?php echo e($notification->agent_name); ?></p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Export</button>
        <a class="btn btn-primary" href="/ui/agent-notifications">Back to Log</a>
    </div>
</section>

<section class="grid-2">
    <div class="card">
        <div class="card-title">Summary</div>
        <p class="card-sub">Sent <?php echo e($notification->sent_at?->format('M d, H:i') ?? '-'); ?></p>
        <div class="list">
            <div class="list-item"><span>Severity</span><span class="badge"><?php echo e(strtoupper($notification->severity ?? 'info')); ?></span></div>
            <div class="list-item"><span>Status</span><span><?php echo e(ucfirst($notification->status)); ?></span></div>
            <div class="list-item"><span>Recipients</span><span><?php echo e($notification->recipients ? implode(', ', $notification->recipients) : '-'); ?></span></div>
        </div>
    </div>
    <div class="card">
        <div class="card-title">Message</div>
        <div class="card-sub">Telegram payload</div>
        <pre class="code-block"><?php echo e($notification->summary); ?></pre>
    </div>
</section>

<section class="card">
    <div class="card-title">Payload</div>
    <div class="card-sub">Structured context captured by the agent</div>
    <pre class="code-block"><?php echo e(json_encode($notification->payload, JSON_PRETTY_PRINT)); ?></pre>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/agent-notification-detail.blade.php ENDPATH**/ ?>