<div class="section-card">
    <h3><?php echo e($section['title']); ?>

        <span class="pill <?php echo e($section['severity'] ?? 'info'); ?>"><?php echo e(strtoupper($section['severity'] ?? 'info')); ?></span>
    </h3>
    <div class="muted"><?php echo e($section['purpose']); ?></div>

    <?php if($section['no_data']): ?>
        <div class="muted">No run data for this agent in the selected window.</div>
    <?php else: ?>
        <?php if(!empty($section['metrics'])): ?>
            <div class="section">
                <strong>Key Metrics</strong>
                <table>
                    <thead>
                        <tr>
                            <th>Metric</th>
                            <th>Value</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $section['metrics']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $metric => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(\Illuminate\Support\Str::headline(str_replace('_', ' ', $metric))); ?></td>
                                <td><?php echo e(is_numeric($value) ? $value : (string) $value); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>

        <?php if(!empty($section['findings'])): ?>
            <div class="section">
                <strong>Top Findings</strong>
                <ul>
                    <?php $__currentLoopData = $section['findings']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $finding): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e(is_array($finding) ? ($finding['title'] ?? json_encode($finding)) : $finding); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <?php if(!empty($section['recommended_actions'])): ?>
            <div class="section">
                <strong>Recommended Actions</strong>
                <ul>
                    <?php $__currentLoopData = $section['recommended_actions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($action); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <?php if(!empty($section['data_confidence'])): ?>
        <div class="section">
            <strong>Data Confidence</strong>
            <ul>
                <?php $__currentLoopData = $section['data_confidence']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($note); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
</div>
<?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/reports/partials/agent_section.blade.php ENDPATH**/ ?>