
<?php ($active = 'inventory'); ?>
<?php ($tenant = \App\Models\Tenant::where('name', 'Fourways Group')->first() ?? \App\Models\Tenant::withCount('assets')->orderByDesc('assets_count')->first()); ?>
<?php ($inventoryItems = $tenant ? \App\Models\InventoryItem::with(['part', 'location'])->where('tenant_id', $tenant->id)->get() : collect()); ?>
<?php ($lowStock = $inventoryItems->filter(fn ($item) => $item->min_quantity !== null && $item->quantity <= $item->min_quantity)->count()); ?>
<?php ($backordered = $inventoryItems->filter(fn ($item) => $item->quantity !== null && $item->quantity <= 0)->count()); ?>
<?php ($fastMovers = min(18, $inventoryItems->count())); ?>
<?php ($locationOptions = $inventoryItems->map(fn ($item) => $item->location?->name)->filter()->unique()->values()); ?>

<?php $__env->startSection('title', 'Inventory'); ?>

<?php $__env->startSection('content'); ?>
<section class="page-head">
    <div>
        <p class="eyebrow">Stores</p>
        <h1>Parts & Inventory</h1>
        <p class="sub">Min/max levels, reorder points, and usage per work order.</p>
    </div>
    <div class="page-actions">
        <button class="btn btn-ghost">Reorder List</button>
        <button class="btn btn-primary">Add Part</button>
    </div>
</section>

<section class="grid-3">
    <div class="card">
        <div class="card-title">Low Stock</div>
        <div class="metric"><?php echo e($lowStock); ?></div>
        <div class="metric-sub">Items below reorder</div>
    </div>
    <div class="card">
        <div class="card-title">Backordered</div>
        <div class="metric"><?php echo e($backordered); ?></div>
        <div class="metric-sub">Awaiting vendor</div>
    </div>
    <div class="card">
        <div class="card-title">Fast Movers</div>
        <div class="metric"><?php echo e($fastMovers); ?></div>
        <div class="metric-sub">30-day top usage</div>
    </div>
</section>

<section class="card filters" data-filter-scope>
    <div class="filter-row">
        <input class="input" placeholder="Search inventory" data-filter-input />
        <select class="select" data-filter-status>
            <option value="all">Status: All</option>
            <option value="reorder">Reorder</option>
            <option value="healthy">Healthy</option>
        </select>
        <select class="select" data-filter-site>
            <option value="all">Location: All</option>
            <?php $__currentLoopData = $locationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e(strtolower($location)); ?>"><?php echo e($location); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <button class="btn btn-ghost" type="button" data-export-button data-export-type="inventory">Export Selected</button>
    </div>
</section>

<section class="card">
    <div class="card-head">
        <div>
            <div class="card-title">Inventory Items</div>
            <div class="card-sub">Main store and site depots</div>
        </div>
        <div class="chip">Main Store</div>
    </div>
    <div class="table">
        <div class="table-row table-head table-row-7">
            <div></div><div>SKU</div><div>Part</div><div>On Hand</div><div>Min</div><div>Max</div><div>Status</div>
        </div>
        <?php $__empty_1 = true; $__currentLoopData = $inventoryItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php ($needsReorder = $item->min_quantity !== null && $item->quantity <= $item->min_quantity); ?>
            <div class="table-row table-row-7" data-row data-row-id="<?php echo e($item->id); ?>" data-status="<?php echo e($needsReorder ? 'reorder' : 'healthy'); ?>" data-site="<?php echo e(strtolower($item->location?->name ?? 'main store')); ?>" data-search="<?php echo e(strtolower(($item->part?->sku ?? '') . ' ' . ($item->part?->name ?? '') . ' ' . ($item->location?->name ?? ''))); ?>">
                <div class="table-select"><input type="checkbox" data-row-select value="<?php echo e($item->id); ?>" /></div>
                <div><a href="/ui/inventory/<?php echo e($item->id); ?>"><?php echo e($item->part?->sku ?? '-'); ?></a></div>
                <div><?php echo e($item->part?->name ?? 'Part'); ?></div>
                <div><?php echo e($item->quantity ?? 0); ?></div>
                <div><?php echo e($item->min_quantity ?? '-'); ?></div>
                <div><?php echo e($item->max_quantity ?? '-'); ?></div>
                <div><span class="badge <?php echo e($needsReorder ? 'badge-warning' : 'badge-live'); ?>"><?php echo e($needsReorder ? 'Reorder' : 'Healthy'); ?></span></div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="table-row table-row-7">
                <div></div><div>No inventory items found.</div><div></div><div></div><div></div><div></div><div></div>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('ui.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\hp\Desktop\AI\SAAS\TAMS\resources\views/ui/inventory.blade.php ENDPATH**/ ?>